var buttonclicked = [];

$(document).ready(function () {
    set_param();
    $("#carambolaPlayer").draggable();
    view_status();
    changeSelect('select#idchannel');

});

function reportLoader() {
    $("#freeze").fadeIn(300);
}

function reportLoaderHide() {
    $("#freeze").fadeOut(300);
}


$(window).on("resize", function () {
    var tblnames = ['list'];
    tblnames.forEach((param) => {
        var $grid = $(`#${param}`);
        newWidth = $grid.closest(".ui-jqgrid").parent().width();
        newHeight = $grid.closest(".ui-jqgrid").parent().height();
        $grid.jqGrid("setGridWidth", newWidth, true);
    });
});

function set_param() {
    $.ajax({
        type: "POST",
        url: "get_content.php?set_param",
        data: {
            idcustomer: 1,
            idgroup: 1,
            idarea: $('#idarea').val(),
            idmachine: $('#idmachine').val(),
            idchannel: $('#idchannel').val(),
        },
        success: function (data) {
            $('#div_param').html(data);
        }
    });
}


// Chiamata a webcontrolOnServer
function callServer(val) {
    set_param();

    var tmpPage = "";

    if ($('#page').val() != '') tmpPage = 'http://' + $('#page').val() + '/Carambola/webcontrolOnServer/';
    else tmpPage = '../webcontrolOnServer/';

    return tmpPage;
}

function changeSelect(elem) {


    if (elem == 'select#idmachine') {

        if ($('select#idarea').val() == 0) {
            $(elem).empty();
            changeSelect('select#idchannel');
        } else {
            $.ajax({
                type: "POST",
                url: "get_content.php?select",
                data: {
                    type: 'idarea',
                    val: $('select#idarea').val(),
                    page: 'index'
                },
                success: function (data) {
                    $(elem).empty();
                    $(elem).html("'" + data + "'");
                    changeSelect('select#idchannel');
                }
            });
        }
    } else if (elem == 'select#idchannel') {

        if ($('select#idmachine').val() == 0) {
            $(elem).empty();
        } else {
            $.ajax({
                type: "POST",
                url: "get_content.php?select",
                data: {
                    type: 'idmachine',
                    val: $('select#idmachine').val(),
                    page: 'index'
                },
                success: function (data) {
                    $(elem).empty();
                    $(elem).html("'" + data + "'");
                    changeSelect('page');
                }
            });
        }
    } else if (elem == 'page') {

        if ($('select#idchannel').val() != 0) {

            $.ajax({
                type: "POST",
                url: "get_content.php?select",
                data: {
                    type: 'idchannel',
                    val: $('select#idchannel').val(),
                    page: 'index'
                },
                success: function (data) {
                    var datasplit = data.split('*');
                    $('#page').val(datasplit[0]);
                    var tmp = "location.href='" + datasplit[1] + "'";
                    $('#listen').html('<a href="#" id="viewListen" onclick="' + tmp + '">Listen</a>');
                    $("a", ".menu").click(function () {
                        return false;
                    }); // disabilito il funzionamento dei pulsanti 
                    set_param();

                    switch (buttonclicked[0]) {
                        case 'viewListen':
                            view_listen();
                            break;
                        case 'viewStatus':
                            view_status();
                            break;
                        case 'viewElement':
                            view_element();
                            break;
                        case 'viewPlaylist':
                            view_playlist();
                            break;
                        case 'viewTemplate':
                            view_template();
                            break;
                        case 'viewClock':
                            view_clock();
                            break;
                        case 'viewLog':
                            view_log();
                            break;
                    }
                }
            });
        } else {
            $('#logochannel').html('');
            $('#listen').html('');
        }
    }
}


function changeButtonColor(button) {
    var buttons = ['viewListen', 'viewStatus', 'viewElement', 'viewPlaylist', 'viewTemplate', 'viewClock', 'viewLog'];

    buttonclicked[0] = button;

    buttons.forEach((item, index) => {

        if (button == item) {
            $('#' + item).removeClass("btn-secondary");
            $('#' + item).addClass("btn-primary");
        } else {
            $('#' + item).removeClass("btn-primary");
            $('#' + item).addClass("btn-secondary");
        }

    });
}


// Status Interfaccia
function view_status() {

    changeButtonColor('viewStatus');
    //reportLoader();
    $.ajax({
        type: "POST",
        url: 'get_content.php?status',
        success: function (data) {
            document.getElementById("main-content").innerHTML = data;
            // reportLoaderHide();
            reloadTime();
            reloadStatus();
        }
    });
}

// Aggiornamento Data-Ora
function reloadTime() {
    var now = new Date();
    var hh = now.getHours();
    var mm = now.getMinutes();
    var ss = now.getSeconds();
    if (hh < 10) hh = "0" + hh;
    if (mm < 10) mm = "0" + mm;
    if (ss < 10) ss = "0" + ss;

    var m = now.getMonth() + 1;
    m = m < 10 ? "0" + m : m;
    var day = now.getDate() < 10 ? "0" + now.getDate() : now.getDate();

    $('#status_now').html(day + '-' + m + '-' + now.getFullYear() + '<br>' + hh + ':' + mm + ':' + ss);
    setTimeout('reloadTime()', 1000);
}

// Lettura file status.xml
function reloadStatus() {

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";

    // console.log("channel " + chprefix);

    var computer = $('#idmachine').val() ? $('#idmachine option:selected').text() : "";
    var path = $('#path').val() ? $('#path').val() : "";

    var tmpPage = callServer();
    var url = tmpPage + 'reloadStatusData.php';
    var url2 = tmpPage + 'reloadStatusTime.php';


    $.ajax({
        type: "POST",
        url: url,
        data: {
            path: path,
            chprefix: chprefix,
            computer: computer,
        },
        success: function (responce) {
            $('#status_data').html(responce);
            $.ajax({
                type: "POST",
                url: url2,
                data: {
                    path: path,
                    chprefix: chprefix,
                    computer: computer,
                },
                success: function (responce) {
                    var data = responce.split('_');
                    $('#status_stat').html(data[0]);
                    $('#status_time').html(data[1]);
                }
            });
        }
    });
    setTimeout('reloadStatus()', 5000);
}

// Element
function view_element() {

    changeButtonColor('viewElement');
    $.ajax({
        type: "POST",
        url: 'get_content.php?element',
        success: function (data) {
            document.getElementById("main-content").innerHTML = data;
            callGridElement();

        }
    });
}



function view_playlist() {

    changeButtonColor('viewPlaylist');

    var tmpPage = callServer();
    var url = tmpPage + 'getFile.php';

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var path = $('#path').val() ? $('#path').val() : "";

    $.post(url, {
        path: path,
        chprefix: chprefix,
        type: 'playlist',
    }).done(function (response1) {
        $.post("get_content.php?playlist", {
            options: response1,
        }).done(function (data) {
            var data = JSON.parse(data);
            document.getElementById("main-content").innerHTML = data.ui;
            sessionStorage.setItem("s_prefix", data.s_prefix);
            callGridPlaylist();
        });

    });
}



function _callGridPlaylist() {

    $('#grid').html('<table id="list"><tr><td></td></tr></table><div id="gridpager"></div>');

    var tmpPage = callServer();
    var url = tmpPage + 'sql_listplaylist_onserver.php';

    var date = "";
    if ($("#datepicker").val()) {
        var datepicker = $("#datepicker").val();
        var date = yyyymmdd(datepicker);
    }

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var idarea = $('#idarea').val() ? $('#idarea').val() : "";
    var idmachine = $('#idmachine').val() ? $('#idmachine').val() : "";
    var idchannel = $('#idchannel').val() ? $('#idchannel').val() : "";
    var path = $('#path').val() ? $('#path').val() : "";
    var filename = $('#playlist').val() ? $('#playlist').val() : "";

    var s_prefix = sessionStorage.getItem("s_prefix");

    jQuery("#list").jqGrid({
        datatype: "json",
        url: url,
        postData: {
            date: date,
            filename: filename,
            chprefix: chprefix,
            path: path,
            idgroup: 1,
            idcustomer: 1,
            idarea: idarea,
            idmachine: idmachine,
            idchannel: idchannel,
            s_prefix: s_prefix,
        },
        colNames: ["RUNTIME", "TABLE ELEMENT", "ID", "TITLE", "CATEGORY", "ARTIST", "SOURCE", "FILENAME", "DURATION", "MARKOUT", "INTRO", "MIXOUT"],
        colModel: [{
                name: 'runtime',
                index: 'runtime',
                width: 30,
                editable: true,
                align: 'left'
            },
            {
                name: 'table_element',
                index: 'table_element',
                width: 50,
                editable: true
            },
            {
                name: 'id_element',
                index: 'id_element',
                width: 50,
                editable: true,
                align: 'right',
                hidden: true
            },
            {
                name: 'title',
                index: 'title',
                width: 100,
                editable: true
            },
            {
                name: 'category',
                index: 'category',
                width: 50,
                editable: true
            },
            {
                name: 'artist',
                index: 'artist',
                width: 100,
                editable: true
            },
            {
                name: 'source',
                index: 'source',
                width: 100,
                editable: true
            },
            {
                name: 'filename',
                index: 'filename',
                width: 100,
                editable: true
            },
            {
                name: 'duration',
                index: 'duration',
                width: 30,
                editable: true,
                align: 'left'
            },
            {
                name: 'markout',
                index: 'markout',
                width: 30,
                editable: true,
                align: 'left'
            },
            {
                name: 'intro',
                index: 'intro',
                width: 30,
                editable: true,
                align: 'left'
            },
            {
                name: 'mixout',
                index: 'mixout',
                width: 30,
                editable: true,
                align: 'left'
            }
        ],
        scroll: 1,
        rowNum: 2000,
        rowTotal: 2000,
        rowList: [10, 20, 30],
        pager: '#gridpager',
        viewrecords: true,
        loadonce: true,
        mtype: "POST",
        gridview: true,
        width: $('#grid').width(),
        height: 500,
        sortorder: "artist",
        caption: "VIEW PLAYLIST",
        emptyrecords: "Nessun dato trovato",
        guiStyle: "bootstrap",
        iconSet: "fontAwesome",
        ignoreCase: true,
        loadComplete: function () {
            var numRows = jQuery('#list').jqGrid('getGridParam', 'reccount');
            if (numRows == 0) jQuery('#list').jqGrid("setGridHeight", 'auto', true);
            else jQuery('#list').jqGrid("setGridHeight", 500, true);

            if ($('#list').getGridParam("postData").filters == null) {
                sessionStorage.setItem("playlistfilters", "none");
            } else {
                var filters = $('#list').getGridParam("postData").filters;
                sessionStorage.setItem("playlistfilters", filters);
            }

        }
    });


    jQuery("#list").jqGrid('navGrid', '#gridpager', {
        edit: false,
        add: false,
        del: false,
        search: false,
        view: false,
        refresh: true
    }, {}, {}, {});
    jQuery("#list").jqGrid('filterToolbar', {
        stringResult: true,
        searchOnEnter: false,
        defaultSearch: 'cn'
    });
}

function printPlaylist(type) {
    var myDate = $('#datepicker').val();
    var gio = yyyymmdd(myDate);
    var pMan = $('#playlist').val();
    var chdesc = $('#idchannel').val() ? $('#idchannel option:selected').text() : "";

    var tmpPage = callServer();

    var s_prefix = sessionStorage.getItem("s_prefix");

    var filterTxt = "";
    var filters = sessionStorage.getItem("playlistfilters");


    if (filters != "none") {
        filters = JSON.parse(filters);
        filters.rules.forEach(function (item) {
            filterTxt += item.field + '=' + item.data + '&';
        });
    }

    var page = tmpPage + 'printPlaylist.php?computer=' + $('#computer').val() + '&chprefix=' + $('#chprefix').val() + '&path=' + $('#path').val() + '&day=' + gio + '&pMan=' + pMan +
        '&type=' + type + '&sprefix=' + s_prefix + '&chdesc=' + chdesc + '&' + filterTxt;
    window.open(page);

}


function playlistSelect() {
    $("#datepicker").val("");
    callGridPlaylist();
}

function datePlaylist() {
    $("#playlist").val("");
    callGridPlaylist();
}

function view_template() {
    changeButtonColor('viewTemplate');

    //reportLoader();
    var tmpPage = callServer();
    var url = tmpPage + 'getFile.php';

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var path = $('#path').val() ? $('#path').val() : "";

    $.post(url, {
        path: path,
        chprefix: chprefix,
        type: 'template',
    }).done(function (response1) {
        $.post("get_content.php?template", {
            options: response1,
        }).done(function (data) {
            document.getElementById("main-content").innerHTML = data;
            callGridTemplate();
        });
    });

}

function _callGridTemplate() {

    $('#grid').html('<table id="list"><tr><td></td></tr></table><div id="gridpager"></div>');

    var tmpPage = callServer();
    var url = tmpPage + 'sql_listtemplate_onserver.php';

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var idarea = $('#idarea').val() ? $('#idarea').val() : "";
    var idchannel = $('#idchannel').val() ? $('#idchannel').val() : "";
    var path = $('#path').val() ? $('#path').val() : "";
    var filename = $('#template').val() ? $('#template').val() : "";

    jQuery("#list").jqGrid({
        url: url,
        postData: {
            idgroup: 1,
            idcustomer: 1,
            chprefix: chprefix,
            idarea: idarea,
            idchannel: idchannel,
            path: path,
            filename: filename
        },
        datatype: "xml",
        colNames: ["DAY OF WEEK", "BEGIN HOUR", "CLOCK ID", "CLOCK NAME"],
        colModel: [{
                name: 'dayofweek',
                index: 'dayofweek',
                width: 50,
                editable: true
            },
            {
                name: 'beginhour',
                index: 'beginhour',
                width: 100,
                editable: true
            },
            {
                name: 'clockid',
                index: 'clockid',
                width: 50,
                editable: true,
                hidden: true
            },
            {
                name: 'clockname',
                index: 'clockname',
                width: 100,
                editable: true
            }
        ],
        scroll: 1,
        rowNum: 2000,
        rowTotal: 2000,
        rowList: [10, 20, 30],
        pager: '#gridpager',
        viewrecords: true,
        loadonce: true,
        mtype: "POST",
        gridview: true,
        width: $('#grid').width(),
        height: 500,
        autoheight: false,
        sortorder: "beginhour",
        caption: "VIEW TEMPLATE",
        emptyrecords: "Nessun dato trovato",
        guiStyle: "bootstrap",
        iconSet: "fontAwesome",
        ignoreCase: true,
        loadComplete: function () {
            var numRows = jQuery('#list').jqGrid('getGridParam', 'reccount');
            if (numRows == 0) jQuery('#list').jqGrid("setGridHeight", 'auto', true);
            else jQuery('#list').jqGrid("setGridHeight", 500, true);
        }
    });

    jQuery("#list").jqGrid('navGrid', '#gridpager', {
        edit: false,
        add: false,
        del: false,
        search: false,
        view: false,
        refresh: true
    }, {}, {}, {});
    jQuery("#list").jqGrid('filterToolbar', {
        stringResult: true,
        searchOnEnter: false,
        defaultSearch: 'cn'
    });
}

function view_clock() {

    changeButtonColor('viewClock');

    var tmpPage = callServer();
    var url = tmpPage + 'getFile.php';

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var path = $('#path').val() ? $('#path').val() : "";

    $.post(url, {
        path: path,
        chprefix: chprefix,
        type: 'clock',
    }).done(function (response1) {
        $.post("get_content.php?clock", {
            options: response1,
        }).done(function (data) {
            document.getElementById("main-content").innerHTML = data;
            callGridClock();
        });

    });
}


function _callGridClock() {
    $('#grid').html('<table id="list"><tr><td></td></tr></table><div id="gridpager"></div>');

    var tmpPage = callServer();
    var url = tmpPage + 'sql_listclock_onserver.php';

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var idarea = $('#idarea').val() ? $('#idarea').val() : "";
    var idchannel = $('#idchannel').val() ? $('#idchannel').val() : "";
    var path = $('#path').val() ? $('#path').val() : "";
    var filename = $('#clock').val() ? $('#clock').val() : "";

    jQuery("#list").jqGrid({
        url: url,
        postData: {
            filename: filename,
            idgroup: 1,
            idcustomer: 1,
            chprefix: chprefix,
            idarea: idarea,
            idchannel: idchannel,
            path: path,
        },
        datatype: "xml",
        colNames: ["TABLE ELEMENT", "TITLE", "CATEGORY", "ARTIST"],
        colModel: [{
                name: 'table_element',
                index: 'table_element',
                width: 50,
                editable: true
            },
            {
                name: 'title',
                index: 'title',
                width: 100,
                editable: true
            },
            {
                name: 'category',
                index: 'category',
                width: 50,
                editable: true
            },
            {
                name: 'artist',
                index: 'artist',
                width: 100,
                editable: true
            }
        ],
        scroll: 1,
        rowNum: 2000,
        rowTotal: 2000,
        rowList: [10, 20, 30],
        pager: '#gridpager',
        viewrecords: true,
        loadonce: true,
        mtype: "POST",
        gridview: true,
        width: $('#grid').width(),
        height: 500,
        sortorder: "table_element",
        caption: "VIEW CLOCK",
        emptyrecords: "Nessun dato trovato",
        guiStyle: "bootstrap",
        iconSet: "fontAwesome",
        ignoreCase: true,
        loadComplete: function () {
            var numRows = jQuery('#list').jqGrid('getGridParam', 'reccount');
            if (numRows == 0) jQuery('#list').jqGrid("setGridHeight", 'auto', true);
            else jQuery('#list').jqGrid("setGridHeight", 500, true);
        }
    });
    jQuery("#list").jqGrid('navGrid', '#gridpager', {
        edit: false,
        add: false,
        del: false,
        search: false,
        view: false,
        refresh: true
    }, {}, {}, {});
    jQuery("#list").jqGrid('filterToolbar', {
        stringResult: true,
        searchOnEnter: false,
        defaultSearch: 'cn'
    });
}


function view_log() {
    changeButtonColor('viewLog');
    $.ajax({
        type: "POST",
        url: 'get_content.php?log',
        success: function (data) {
            document.getElementById("main-content").innerHTML = data;
            callGridLog();
        }
    });
}


function _callGridLog() {
    $('#grid').html('<table id="list"><tr><td></td></tr></table><div id="gridpager"></div>');

    var tmpPage = callServer();
    var url = tmpPage + 'sql_listlog_onserver.php';

    var datepicker = $("#datepicker").val();
    var date = yyyymmdd(datepicker);

    var chprefix = $('#idchannel').val() ? $('#idchannel option:selected').attr('data-acronym') : "";
    var idarea = $('#idarea').val() ? $('#idarea').val() : "";
    var idchannel = $('#idchannel').val() ? $('#idchannel').val() : "";
    var path = $('#path').val() ? $('#path').val() : "";
    var computer = $('#idmachine').val() ? $('#idmachine option:selected').text() : "";

    jQuery("#list").jqGrid({
        url: url,
        postData: {
            date: date,
            idgroup: 1,
            idcustomer: 1,
            chprefix: chprefix,
            idarea: idarea,
            computer: computer,
            idchannel: idchannel,
            path: path,
        },

        datatype: "json",
        colNames: ["ON AIR PLAYED HOURS", "TITLE", "ARTIST", "FILE", "TYPE", "LENGTH", "ON AIR PLAYED DAY", "LENGTH ON AIR"],
        colModel: [{
                name: 'onairplayedhours',
                index: 'onairplayedhours',
                width: 50,
                editable: true,
                align: "center"
            },
            {
                name: 'title',
                index: 'title',
                width: 120,
                editable: true
            },
            {
                name: 'artist',
                index: 'artist',
                width: 120,
                editable: true
            },
            {
                name: 'file',
                index: 'file',
                width: 100,
                editable: true
            },
            {
                name: 'type',
                index: 'type',
                width: 50,
                editable: true,
                hidden: true
            },
            {
                name: 'length',
                index: 'length',
                width: 50,
                editable: true,
                hidden: true
            },
            {
                name: 'onairplayedday',
                index: 'onairplayedday',
                width: 50,
                editable: true,
                hidden: true
            },
            {
                name: 'lengthonair',
                index: 'lengthonair',
                width: 50,
                editable: true,
                align: "center"
            }
        ],
        scroll: 1,
        rowNum: 2000,
        rowTotal: 2000,
        rowList: [10, 20, 30],
        pager: '#gridpager',
        viewrecords: true,
        loadonce: true,
        mtype: "POST",
        gridview: true,
        width: $('#grid').width(),
        height: 300,
        sortname: "onairplayedhours",
        sortorder: "asc",
        caption: "VIEW LOG",
        emptyrecords: "Nessun dato trovato",
        guiStyle: "bootstrap",
        iconSet: "fontAwesome",
        ignoreCase: true,
        loadComplete: function () {
            var numRows = jQuery('#list').jqGrid('getGridParam', 'reccount');
            if (numRows == 0) jQuery('#list').jqGrid("setGridHeight", 'auto', true);
            else jQuery('#list').jqGrid("setGridHeight", 500, true);

            if ($('#list').getGridParam("postData").filters == null) {
                sessionStorage.setItem("logfilters", "none");
            } else {
                var filters = $('#list').getGridParam("postData").filters;
                sessionStorage.setItem("logfilters", filters);
            }
        }
    });
    jQuery("#list").jqGrid('navGrid', '#gridpager', {
        edit: false,
        add: false,
        del: false,
        search: false,
        view: false,
        refresh: true
    }, {}, {}, {});
    jQuery("#list").jqGrid('filterToolbar', {
        stringResult: true,
        searchOnEnter: false,
        defaultSearch: 'cn'
    });
}


function printLog(type) {
    var myDate = $('#datepicker').val();
    var gio = yyyymmdd(myDate);
    var tmpPage = callServer();
    var chdesc = $('#idchannel').val() ? $('#idchannel option:selected').text() : "";

    var filterTxt = "";
    var filters = sessionStorage.getItem("logfilters");
    if (filters != "none") {
        filters = JSON.parse(filters);
        filters.rules.forEach(function (item) {
            filterTxt += '&' + item.field + '=' + item.data;
        });
    }

    var page = tmpPage + 'printLog.php?computer=' + $('#computer').val() + '&chprefix=' + $('#chprefix').val() +
        '&path=' + $('#path').val() + '&day=' + gio + '&type=' + type + '&chdesc=' + chdesc + filterTxt;

    //console.log(filterTxt);
    window.open(page);
}

function yyyymmdd(date) {
    var arr = date.split("-");
    var date = arr[0] + arr[1] + arr[2];
    return date;
}



function view_listen() {
    var idchannel = $('#idchannel').val() ? $('#idchannel').val() : "";
    //changeButtonColor('viewListen');
    $.ajax({
        type: "POST",
        url: 'get_content.php?listen',
        data: {
            idchannel: idchannel
        },
        success: function (data) {
            var data = JSON.parse(data);
            //document.getElementById("main-content").innerHTML = data.ui;
            $.when($('#player').fadeOut())
                .done(function () {
                    $('#loadAnimation').fadeIn();
                });

            $('#viewListen').prop("disabled", true);
            $('#carambolaPlayer').fadeIn();
            //console.log(data.listen);
            carambolaPlayer(data.listen, "Streamer");
        }
    });
}

//PLAYER
var isCarambolaPlayerActive = false;
var carambolaPlayerInterval;


function carambolaPlayer(path, name) {

    //console.log(path);
    if (path == "" || path == null) {

        $.when($('#loadAnimation').fadeOut())
            .done(function () {

                $('#player').empty();
                $('#player').append('<div class="text-danger">This audio is either unavailable or not suported by this browser </div>');
                $('#player').fadeIn();
                $('#viewListen').prop("disabled", false);
            });
        return false;
    }


    document.getElementById('carambolaPlayerCurrentTime').innerHTML = "00:00:00";

    var extension = path.split('.').pop();

    if (extension != "mp3" && extension != "wav") {}

    carambolaPlayerInterval = setInterval(function () {

        carambolaPlayerUpdateStatus();

    }, 500);

    document.getElementById('actualAudioPlayer').src = path;

    document.getElementById('audioPlayerOBJ').load();

    document.getElementById('audioPlayerOBJ').play();

    $('#carambolaPlayer').fadeIn(100);

    isCarambolaPlayerActive = true;

}


function carambolaPlayerUpdateStatus() {


    if (document.getElementById('audioPlayerOBJ').paused && document.getElementById('audioPlayerOBJ').duration == document.getElementById('audioPlayerOBJ').currentTime) {
        document.getElementById('carambolaPlayerStatusImg').src = 'ui/playbutton.png';
        document.getElementById('audioPlayerOBJ').currentTime = 0;
    }

    var currentTime = document.getElementById('audioPlayerOBJ').currentTime;
    var currentTime_parsed = ms_to_hhmmss(currentTime * 1000);

    document.getElementById('carambolaPlayerCurrentTime').innerHTML = currentTime_parsed;
    if (document.getElementById('audioPlayerOBJ').currentTime > 0 && !document.getElementById('audioPlayerOBJ').paused) {
        $('#carambolaPlayerStatusImg').addClass("fa-pause").removeClass("fa-play");

        $.when($('#loadAnimation').fadeOut())
            .done(function () {
                $('#player').fadeIn();
            });
    }

}

function ms_to_hhmmss(ms_part) {

    var duration = "";
    var sec_len = parseInt(ms_part / 1000);
    var actual_sec = sec_len % 60;
    var mins_len = sec_len / 60;
    var actual_mins = mins_len % 60;
    var hours_len = parseInt(mins_len / 60);

    if (hours_len >= 10) {
        if (hours_len >= 24) {

            hours_len -= 24;

            if (hours_len < 10)
                duration += "0" + parseInt(hours_len) + ":";
            else
                duration += parseInt(hours_len) + ":";
        } else
            duration += parseInt(hours_len) + ":";
    } else
        duration += "0" + parseInt(hours_len) + ":";

    if (actual_mins >= 10)
        duration += parseInt(actual_mins) + ":";
    else
        duration += "0" + parseInt(actual_mins) + ":";

    if (actual_sec >= 10)
        duration += parseInt(actual_sec);
    else
        duration += "0" + parseInt(actual_sec);

    return duration;
}

function carambolaPlayerPlay() {

    if (!document.getElementById('audioPlayerOBJ').paused && document.getElementById('audioPlayerOBJ').duration > 0) {
        $('#carambolaPlayerStatusImg').addClass("fa-play").removeClass("fa-pause");
        document.getElementById('audioPlayerOBJ').pause();
    } else {
        $('#carambolaPlayerStatusImg').addClass("fa-pause").removeClass("fa-play");
        document.getElementById('audioPlayerOBJ').play();
    }

}

function closeCarambolaPlayer() {

    isZelosPlayerActive = false;
    if (document.getElementById('actualAudioPlayer') != null) {
        document.getElementById('actualAudioPlayer').src = "";
    }
    if (document.getElementById('audioPlayerOBJ') != null) {
        document.getElementById('audioPlayerOBJ').pause();
    }
    $('#carambolaPlayer').fadeOut(100);
    clearTimeout(carambolaPlayerInterval);

    $('#carambolaPlayer').fadeOut();
    $('#viewListen').prop("disabled", false);

}