$(document).ready(function () {
  loadTopbar(1);
  if ($('#collapse').children().length == 0) $('#changeApp').hide();
});

$(window).on("resize", function () {

  var tables = ['#jqGrid', '#jqGridI'];
  tables.forEach((grid) => {
    var $grid = $(grid);
    var newWidth = $('#table_div').width();
    var newHeight = ($('#table_div').height() / 100) * 93;
    $grid.jqGrid("setGridWidth", newWidth, true);
    $grid.jqGrid("setGridHeight", newHeight, true);
  });

});

function wideUnwideMenu() {
  $("#manuLeftSide").toggleClass("untoggled toggled");
  $("#sidebarToggle i").toggleClass("fa fa-bars fa fa-times");
  if ($("#manuLeftSide").hasClass("toggled")) {
    $(".menu-text").show();
    $("#shadow").fadeIn(200);
  } else {
    $(".menu-text").hide();
    $("#shadow").fadeOut(200);
  }
}


function loadTopbar(index) {

  $.post("get_content.php?loadTopbar", {
    index: index
  }).done(function (data) {

    document.getElementById("top-bar").innerHTML = data;

    if (index == 1) {
      $("#datefrom").datepicker($.datepicker.regional[data.language]);
      $("#dateto").datepicker($.datepicker.regional[data.language]);
    } else if (index == 4) { // pagina setup

      $("#top-bar").fadeIn();

      var btn1 =
        "<button id='setup_button1' onclick='displaySetup(1)' class='input-report setupbuttons' style=' color: #1a1a1a;width: 100%; float: left; border-right: 0.05vw solid #ababab; height: 100%; text-align: center; padding: 0; text-transform: uppercase;'>" +
        "<?php echo webapp_translator('Philo Advertising Cron')?>" +
        "</button>";

      document.getElementById("top-bar-two").innerHTML = btn1;
      $("#top-bar-two").fadeIn();

      $.post("get_content.php?cronSetup", {}).done(function (data) {
        document.getElementById("main-content").innerHTML = data;
        displaySetup(1);
      });

    }
  })

}

function loadSETUP() {
  loadTopbar(4);
  document.getElementById("main-content").innerHTML = "";
  setupBeingAltered = false;
}

function loadPhilo() {
  loadTopbar(1);
  document.getElementById("main-content").innerHTML = "";
  setupBeingAltered = false;
}


function displaySetup(index) {

  $(".setuppage").stop();
  $(".setupbuttons").css({
    backgroundColor: "#bababa",
    fontWeight: "normal"
  });

  $.when($(".setuppage").fadeOut(150)).done(function () {
    $("#setup_page" + index).fadeIn(300);
    document.getElementById("setup_button" + index).style.backgroundColor =
      "rgb(201, 201, 201)";
    document.getElementById("setup_button" + index).style.fontWeight = "bold";
  });

}

function displayTable() {
  var datefrom = $("#datefrom").val();
  var dateto = $("#dateto").val();
  var print = $("#print").val();


  var from = yyyymmdd(datefrom);
  var to = yyyymmdd(dateto);
  if (from.getTime() > to.getTime()) return false;

  $.post("get_content.php?loadui", {
    print: print
  }).done(function (data) {

    document.getElementById('main-content').innerHTML = data;

    $('#weeks').find('option').remove();
    getWeeks(datefrom, dateto).forEach(element => {
      var week = element.toString().split(",");
      $('#weeks').append(new Option(week[0] + '-->' + week[1]));
    });

    $("#week_div").hide();

    if (print == 1) {
      table_listadv();
    } else {
      $("#week_div").show();
      table_advcheduled();
    }

  });

}




function reloadTable() {

  var print = $("#print").val();
  var preradio = $("#idradio").find(":selected").attr("data-preradio");
  var idradio = $("#idradio").val();
  var dayfrom = $('#datefrom').val();
  var dayto = $('#dateto').val();

  if (print == 2) {
    var week = $("#weeks").find(":selected").text().split('-->');
    var dayfrom = week[0].trim();
    var dayto = week[1].trim();

    var orarivuoti = $("#orarivuoti").is(":checked") ? 1 : 0;

    $("#jqGridI").jqGrid('setGridParam', {
      url: 'sql/sql_advSchedule.php',
      postData: {
        'dayfrom': dayfrom,
        'dayto': dayto,
        'orarivuoti': orarivuoti,
        'preradio': preradio,
        'idradio': idradio
      },
    }).trigger('reloadGrid');
  } else if (print == 1) {

    $("#jqGrid").jqGrid('setGridParam', {
      url: 'sql/sql_listAdv.php',
      postData: {
        'dayfrom': dayfrom,
        'dayto': dayto,
        'preradio': preradio,
        'idradio': idradio
      }
    }).trigger('reloadGrid');
  }

}



function printPhilo() {

  var from = $("#datefrom").val();
  var to = $("#dateto").val();
  var idradio = $("#idradio").val();
  var preradio = $("#idradio").find(":selected").attr("data-preradio");
  var orarivuoti = $("#orarivuoti").is(":checked") ? 1 : 0;
  var print = $("#print").val();
  var pathprint = "print/printPhilo.php";

  if (print == 2) {
    var week = $('#weeks').find(":selected").text().split("-->");
    from = week[0].trim();
    to = week[1].trim();
  }

  window.open(`${pathprint}?preradio=${preradio}&idradio=${idradio}&dayfrom=${from}&dayto=${to}&orarivuoti=${orarivuoti}&oper=${print}`);
}

function openDesigner() {

  var from = $("#datefrom").val();
  var to = $("#dateto").val();
  var idradio = $("#idradio").val();
  var preradio = $("#idradio").find(":selected").attr("data-preradio");
  var orarivuoti = $("#orarivuoti").is(":checked") ? 1 : 0;
  var print = $("#print").val();
  var pathprint = "print/openDesigner.php";

  if (print == 2) {
    var week = $('#weeks').find(":selected").text().split("-->");
    from = week[0].trim();
    to = week[1].trim();
  }

  window.open(`${pathprint}?preradio=${preradio}&idradio=${idradio}&dayfrom=${from}&dayto=${to}&orarivuoti=${orarivuoti}&oper=${print}`);
}


// Divide il periodo in settimane precise lun-dom
function getWeeks(datefrom, dateto) {
  //console.log(datefrom, dateto)
  var dateto = dateto.split("-");
  var to = new Date(dateto[2], dateto[1] - 1, dateto[0]);
  var lastday = new Date(
    to.getFullYear(),
    to.getMonth(),
    to.getDate() + (to.getDay() == 0 ? 0 : 7) - to.getDay()
  );

  var datefrom = datefrom.split("-");
  var from = new Date(datefrom[2], datefrom[1] - 1, datefrom[0]);
  var first, last = 0;
  var weeks = [];

  while (true) {
    first = new Date(
      from.getFullYear(),
      from.getMonth(),
      from.getDate() + (from.getDay() == 0 ? -6 : 1) - from.getDay()
    );

    last = new Date(
      from.getFullYear(),
      from.getMonth(),
      from.getDate() + (from.getDay() == 0 ? 0 : 7) - from.getDay()
    );

    weeks.push([ddmmyyyy(first), ddmmyyyy(last)]);
    if (last.getDate() === lastday.getDate()) break;

    from = new Date(last.getFullYear(), last.getMonth(), last.getDate() + 1);
  }

  //console.log(weeks);
  return weeks;
}


function changeWeekRP(type) {

  var datefrom = $("#datefrom").val();
  datefrom = datefrom.substr(3, 2) + "-" + datefrom.substr(0, 2) + "-" + datefrom.substr(6, 8);
  var dfrom = new Date(datefrom);

  var dateto = $("#dateto").val();
  dateto = dateto.substr(3, 2) + "-" + dateto.substr(0, 2) + "-" + dateto.substr(6, 8);
  var dto = new Date(dateto);

  var diffdays = getDifferenceInDays(dfrom, dto);

  if (type == "next") {
    if (dfrom.getTime() == dto.getTime()) {
      var from = dfrom;
      var to = new Date(dto.setDate(dto.getDate() + 6));
    } else {
      if (diffdays != 6) {
        console.log(diffdays);
        var to = new Date(dateto);
        var from = new Date(dto.setDate(dto.getDate() - 6));
      } else {
        var from = new Date(dfrom.setDate(dfrom.getDate() + 6));
        var to = new Date(dto.setDate(dto.getDate() + 6));
      }
    }
  } else {
    if (dfrom.getTime() == dto.getTime()) {
      var from = new Date(dfrom.setDate(dfrom.getDate() - 6));
      var to = dto;
    } else {
      if (diffdays != 6) {
        var from = new Date(datefrom);
        var to = new Date(dfrom.setDate(dfrom.getDate() + 6));
      } else {
        var from = new Date(dfrom.setDate(dfrom.getDate() - 6));
        var to = new Date(dto.setDate(dto.getDate() - 6));
      }
    }
  }

  $("#datefrom").val(ddmmyyyy(from));
  $("#dateto").val(ddmmyyyy(to));

  $('#weeks').find('option').remove();
  getWeeks(ddmmyyyy(from), ddmmyyyy(to)).forEach(element => {
    var week = element.toString().split(",");
    $('#weeks').append(new Option(week[0] + '-->' + week[1]));
  });
}


function getDifferenceInDays(date1, date2) {
  const diffInMs = Math.abs(date2 - date1);
  return Math.round(diffInMs / (1000 * 60 * 60 * 24));
}

function yyyymmdd(date) {
  var date = date.substr(6, 8) + "-" + date.substr(3, 2) + "-" + date.substr(0, 2);
  return new Date(date);
}

function ddmmyyyy(d) {
  var dd = String(d.getDate()).padStart(2, '0');
  var mm = String(d.getMonth() + 1).padStart(2, '0'); //January is 0!
  var yyyy = d.getFullYear();
  return dd + '-' + mm + '-' + yyyy;
}

function saveCurrentCronConfig() {
  // cron esportazione pubblicità 
  var exportadv_timeexecution = $("#exportadv_time").val();
  var exportadv_pathexport = $("#exportadv_pathexport").val(); // percorso salvataggio file xml generati
  var exportadv = {
    "timeexecution": exportadv_timeexecution,
    "pathexport": exportadv_pathexport,
  };

  $.post("get_content.php?saveCurrentCronConfig", {
    exportadv: JSON.stringify(exportadv)
  }).done(function (data) {
    var data = JSON.parse(data);

    if (data['title'] == 'error_pathexport') {

      $('#exportadv_pathexport').animate({
        'background-color': '#d15252'
      }, {
        duration: 250
      }).delay(2000).animate({
        'background-color': '#bababa'
      }, {
        duration: 250
      });

      $('#error_pathexport').text(data['text']);
      $('#error_pathexport').fadeIn();

    } else {
      $('#error_pathexport').fadeOut();
      Swal.fire({
        position: "center",
        icon: data["icon"],
        text: data["text"],
        timer: 2000,
      });
    }
  });

}