<?php

// Streamer Ingest Digital Content Package alias StreamerIDCP c/o Riva Stefano

// About: Remake della funzione originale in uso da Luglio 2018 di import dei contenuti DCP in maniera selettiva sui contenuti delle CPL selezionate.
// Supporta la copia da FTP se provvista di URL ftp:// credenziali @ indirizzo:porta / *PERCORSO* .
// I parametri in ingresso (path sorgenti) sono encryptati in aes256 (pass: 123456) per evitare che caratteri non supportati dal CLI non venissero correttamente passati in ingresso.
// Modificate piccole porzioni di codice per adattare l'IDCP alla nuova versione di Streamer. il 99% del processo è ancora rimasto identico all'originale.

// Inizato il 19/11/2019 @ v 1.0
// Migliorato il 22/11/2019 @ v 1.1 [ Migliorata copia intelligente e adattata anche per l'FTP nella stessa funzione, Copia dei font dalla PKL che fanno solo parte dei sottitoli della CPL ]
// Quick Update il 07/01/2020 @ v 1.2 [ La radice della PROPS sarà sempre maiuscola ]
// Aggiornato il 14/02/2020 @ v 1.3 [ Nel caso 1 ASSETMAP -> PIù PKL\CPL, le PKL verranno copiate ed inserite in tutti gli AssetMap delle varie cartelle che andranno a formarsi durante la copia ]
// Quick Update il 09/06/2020 @ v 1.3.1 [Nel caso in cui vi siano stati sia AnnotationText che ContentTitleText, la CPL non sarebbe stata copiata poichè in StreamerIDCP non vi era alcun controllo sui 2 campi affinchè si prendesse SOLO quello valido, ossia un reale testo CPL secondo le norme. Aggiornato con il controllo come da versione client Browser]
// Quick Update il 15/07/2020 @ v 1.3.2 [ Modificata la funzione parseCPLContent, verrà utilizzata una regex per rimuovere tutti gli indici <*:indice> e </*:indice> che rendevano l'individuazione dei reel nelle cpl difficile da parte del Processo IDCP. ]
// Aggiornato il 20/07/2020 @ v 1.4 [ Racchiude tutte le modifiche dalla 1.3 in una release ufficiale. Ridefinito il parsing della CPL in parseCPLContent() con una nuova Regex rispetto alla 1.3.2 ]
// Aggiornato il 24/08/2020 @ v 1.4b [ Modificato il metodo di riconoscimento delle DCP da copiare mediante la UUID della CPL invece di utilizzare l'ANNOTATIONTEXT o CONTENTTITLETEXT che era effettivamente un'idea stupida in primis.. ma avendolo fatto nel 2017\2018 è giustificabile dal mio essere incapace nel gestire questa semplice operazione.. hah]
// Quick Update il 03/09/2020 @ v 1.4c [ Invertito il controllo su AnnotationText e ContentTitleText. Verifichiamo prima il ContentTitleText e poi l'AnnotationText... sperando che sia effettivamente così lo standard con le cpl nuove.. ]
// Quick Update il 15/10/2020 @ v 1.4d [ Aggiunto ClosedCaption per le CPL grazie al film di Totti ]
// Aggiornato il 04/02/2021 @ v 1.5 [ Risolta compatibilità per lo streaming con Dolby, i file che sono già stati copiati verranno comunque aggiunti nell'assetmap puntando ../*cartella_cpl_con_quel_file/*quel_file , il Barco ignorerà questi assets perchè li mappa già caricando le CPL nella props (li tiene in memoria, sa dove sono), l'hula li registra quindi sa sempre dove sono, il Dolby li va a pescare così. INOLTRE, andiamo a generare anche la PKL ad-hoc per ogni CPL, rimossa la copia delle PKL extra....... chissà se sarà long term ok.]
// Quick Update il 10/02/2021 @ v1.5b [Aggiunti ultimi 5 caratteri della uuid CPL al nome della cartella della CPL all'interno di Props (vedere ADN in francia...) + Scriviamo l'issuedate originale per Assetmap e PKL]
// Aggiornato il 19/03/2021 - 22/03/2021 @ v1.6 [Implementato per lo StreamerV2 , RIMOSSO lo streamer iLink, il link in m_dcp viene fatto SUBITO dalle api in nodejs, una volta finita la copia viene flaggato a 0 RefrainMixIn che significa "questa CPL è stata copiata" ]
// Quick update il 12/04/2021 @v1.6b [Chiuso il giro dell'ingest nel datastore, una volta completato mette in verify per ogni datastore i contenuti. Poi ci penserà lo StreamerCop a certificare i contenuti dell'HULA ecc...]



$VERSION_IDCP = "1.6b";

include(__DIR__ . "/db_connection.php");
require_once(__DIR__ . "/uuid.php");

// variabili da db
$queryDatastore = mysqli_query($db,"SELECT STRING_VALUE FROM m_setup WHERE KEY1 = 'CINEMONITOR' AND KEY2='DATASTORE' ");
if($assocDatastore = mysqli_fetch_assoc($queryDatastore)){

  $datastore_path = $assocDatastore['STRING_VALUE'];

} else {

  $datastore_path = "/datastore/"; // datastore default per il nostro sistema se non venisse trovato il record di setup.

}

// ARRAY DELLE ANNOTATION TEXT
$DCP_ANNOTATION_TEXTS = array();

// PATH DI SORGENTE DELLA DCP
$SOURCE_PATH_DCP = array();

// ANNOTATIONTEXTS DA COPIARE TRUE/FALSE
$CPL_COPY_ARRAY = array();


$count=count($_SERVER['argv']);
$gcount=intval($_SERVER['argv'][$count-2]);
$ccount=intval($_SERVER['argv'][$count-3]);

// DESTINAZIONE COPIA
$destination=$_SERVER['argv'][$count-4];


$ids=array();


$index_c=0;
$index_c2=1;
for($i=1; $i<=$ccount;$i++){

  $tocopy[$index_c]=$_SERVER['argv'][$index_c2];
  $index_c2++;
  $tocopy2[$index_c]=$_SERVER['argv'][$index_c2];
  $index_c2++;
  $index_c++;

}

for($x=0;$x<count($tocopy);$x++){

  $CPL_COPY_ARRAY[$tocopy2[$x]]=$tocopy[$x];
  $DCP_ANNOTATION_TEXTS[$x]=$tocopy2[$x];

}

$i++;
$index_g=0;

for($s=$index_c2;$s<($gcount+$index_c2);$s++){

  $SOURCE_PATH_DCP[$index_g] = base64_decode($_SERVER['argv'][$s]);
  $index_g++;

}

$foldersArray=array();
$counter_folders=0;

// ARRAY GLOBALE CHE LISTA LE UUID X OGNI COPIA. CIò SIGNIFICA CHE, UN CONTENUTO CHE DOVREBBE ESSERE COPIATO UNA SOLA VOLTA PER CONTENUTO PUò ESSERE VERIFICATO DA QUI
$UUID_ALREADY_COPIED = array();

// ARRAY CHE CONTIENE I PATH DALLA PROPS IN POI PER I FILE GIà COPIATI, SE SONO NELLA CPL MA VANNO SKIPPATI X IL BARCO, LI SCRIVO COMUNQUE NELL'ASSET MAP PER IL DOLBY
$UUID_ALREADY_COPIED_PATH = array();

// Array dei different asset di una CPL
$arrayCPLAssets = array( 0 => "MainPicture" , 1 => "MainSound" , 2 => "MainSubtitle" , 3 => "MainStereoscopicPicture" , 4 => "AuxData" , 5 => "ClosedCaption");


// DEBUG VARIABILI


print_r($SOURCE_PATH_DCP);
print_r($DCP_ANNOTATION_TEXTS);
print_r($CPL_COPY_ARRAY);


$IS_FTP_TRANSFER = FALSE;
$FTP_CONNESSION = NULL;
$RADIX_FTP = "";


// Descrivo il processo esecutivo:

// Il primo array, source_path_dcp contiene le cartelle effettivamente selezionate nella fase di ingest dall'interfaccia di Streamer. Ciò significa che , il numero delle path SORGENTE
// può effettivamente e logicamente essere inferiore al numero di CPL da copiare nel processo.
// Quindi, partendo dalla path, effettuo una ricerca di tutti i file al suo interno per identificare tutti gli assetmap e di conseguenza le CPL.

// Trovate le CPL, io so per certo se deve o non deve essere copiata.

// Se la CPL in questione è da copiare, allora avendo mappato tutti i file del suo assetmap, li devo copiare nella cartella che, sarà all'interno della cartella chiamata come la radice
// del suo annotationtext.

// Se non deve essere copiata, passo alla prossima\prossimo assetmap finchè tutti i file non vengono effettivamente parsati.

// .................INIZIO PROCESSO...............

// ciclo principale di parse delle folder
for($main = 0; $main < count($SOURCE_PATH_DCP); $main++){

  // ========================= FASE PRELIMINARE: LEGGO IL CONTENUTO DELLA SORGENTE =================================
  // Questa funzione mi ritorna un array contenente tutti i file per ogni assetmap individuato nella cartella sorgente in input con stato 1\0, path globale da /media/... e uuid dei file.
  // ===============================================================================================================

  // VERIFICO SE IL PATH VIENE DA UN FTP E LO SPESSO PER OTTENERE QUELLO GLOBALE E CONNETTERMI IN FTP PER OTTENERE IL FILESIZE.
  if( strpos(strtoupper($SOURCE_PATH_DCP[$main]) , 'FTP://') !== FALSE ){

    // ftp://xd:xd@10.55.42.252:21///

    // levo la stringa di FTP
    $tempCredentials = str_replace( "ftp://" , '' , $SOURCE_PATH_DCP[$main] );
    $explodeDivision = explode("/" , $tempCredentials);
    $FTP_STRING = $explodeDivision[0]; // qua ho solo xd:xd@10.55.42.252:21
    $UserPass = explode("@" , $FTP_STRING);

    $FTP_username_explode = explode(":" , $UserPass[0]);

    $FTP_USERNAME = $FTP_username_explode[0];
    $FTP_PASSWORD = $FTP_username_explode[1];

    $FTP_IpPort = explode(":" , $UserPass[1]);

    $FTP_ADDRESS = $FTP_IpPort[0];
    $FTP_PORT = $FTP_IpPort[1];

    //die($FTP_USERNAME." , ".$FTP_PASSWORD." @ ".$FTP_ADDRESS." , ".$FTP_PORT);

    // VARIABILE DI REPLACE PER IL PATH IN FTP
    $RADIX_FTP = "ftp://".$FTP_USERNAME.":".$FTP_PASSWORD."@".$FTP_ADDRESS.":".$FTP_PORT;

    // MI COLLEGO IN FTP DOVE FTP_CONNESSION è UNA VARIABILE GLOBALE RAGGIUNGIBILE DA TUTTE LE FUNZIONI.


    // setto la global var per riconoscere che stiamo trasferendo in ftp
    $IS_FTP_TRANSFER = TRUE;

  }

  //echo $SOURCE_PATH_DCP[$main].PHP_EOL;

  $CURRENT_FOLDER_MAP = MapMyDCP($SOURCE_PATH_DCP[$main]);

  //print_r($CURRENT_FOLDER_MAP);
  //die();


  // ========================= FASE 1: CERCO LE PKL PER OGNI ASSETMAP INDIVIDUATO =================================
  // Devo cercare le PKL Per ogni assetmap. Una volta individuate, me le salvo in un array per passare alla FASE 2.
  // ==============================================================================================================

  // Passo gli assetmap
  for($assetmaps_c = 0; $assetmaps_c < count($CURRENT_FOLDER_MAP); $assetmaps_c++){

    $assetmaps = "ASSETMAP_".$assetmaps_c;

    if(!isset($CURRENT_FOLDER_MAP[$assetmaps])){

      continue;

    }


    // Mi segno il filename dei font individuati, alla fine del processo di copia che crea anche le cartelle in CPL_IDCP, faccio passare questo array che sposta i sottotitoli
    $ARRAY_FONTS = array();



    // Passo gli asset di questo assetmap e cerco le PKL
    for($inner_assetmap = 0; $inner_assetmap < count($CURRENT_FOLDER_MAP[$assetmaps]['ASSETS']); $inner_assetmap++){

      // Avendo l'assetmap nel count degli assets è probabile che contando 1 in più lo vada a cercare come indice, quindi, lo skippo evitando l'errore.
      if( !isset($CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap] ) )
        continue;

      // trovo la pkl
      if( isset($CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap]['PKL']) ){

        $CURRENT_PKL_UUID = $CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap]['UUID'];

      // verifico che la PKL sia su disco
      if( $CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap]['Status'] == '1' ){

        // array contenente tutte le CPL per questa CPL con filename , uuid e annotationtext (che ci servirà per sapere se va copiato o meno il contenuto)
        $CPL_UUID_FROM_PKL = getCPLfromPKL($CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap]['Filename'] , $CURRENT_FOLDER_MAP[$assetmaps]['UUID']);
        //print_r($CPL_UUID_FROM_PKL);

        for($cpl_files = 0; $cpl_files < count($CPL_UUID_FROM_PKL); $cpl_files++ ){

          // l'annotationtext trovato è nell'array richiesto
          // NUOVA VERSIONE, GUARDIAMO L'UUID INVECE CHE L'ANNOTATIONTEXT X EVITARE CAOS
          if(isset($CPL_COPY_ARRAY[ $CPL_UUID_FROM_PKL[$cpl_files]['UUID'] ])){

            // IL CONTENUTO DI QUESTA CPL è DA COPIARE!
            if( $CPL_COPY_ARRAY[ $CPL_UUID_FROM_PKL[$cpl_files]['UUID'] ] == 'true' ){

              // ========================= FASE 2: COPIO I CONTENUTI DELLA CPL NEL DATASTORE  =================================
              // Ora che ho trovato la CPL e conosco i file che ne fanno parte, non mi resta che spostarli nel datastore come richiesto e dove richiesto.
              // ==============================================================================================================
              CPL_IDCP( $CPL_UUID_FROM_PKL[$cpl_files] , $CURRENT_FOLDER_MAP[$assetmaps]['UUID'] , $destination , $CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'][$inner_assetmap]['Filename'] , $CURRENT_FOLDER_MAP[$assetmaps]['ASSETS']['ASSETMAP']['Filename'] , $CURRENT_PKL_UUID , $CURRENT_FOLDER_MAP[$assetmaps]['ASSETS'] );

            } else {

              //echo $CPL_UUID_FROM_PKL[$cpl_files]['ANNOTATIONTEXT']." no.".PHP_EOL;

            }

          } else {

            //echo "NOT SET??? ".$CPL_UUID_FROM_PKL[$cpl_files]['ANNOTATIONTEXT'].PHP_EOL;

          }

        }

        // Le cpl, se richieste in copy, sono già state copiate nel ciclo sopra.

      }else{

        // LA PKL NON è STATA TROVATA MA NON è PRESENTE FISICAMENTE NELLA CARTELLA!

      }


      }

    }



  } // fine assetmap





} // fine main for



///////////////////////////
///////// FINE ////////////
///////////////////////////

exit;

///////////////////////////////////////
// IL PROCESSO ESCE, COPIA TERMINATA //
///////////////////////////////////////


// ======================= //
// FUNZIONI CORE DELL'IDCP //
// ======================= //


function MapMyDCP($path){

    //include("check_session.php");
    //include("db_connection.php");

    $path_cpl = $path."/";

    if(!file_exists($path_cpl))
      return "cpl_not_exist";

    //echo get_parent_folder($path_cpl);

    //echo $path_cpl.PHP_EOL;

    $files = getDirContents( $path_cpl );

    //print_r($files);

    if(count($files)==0)
      return "ERROR_FILE_READ ".$path_cpl;

    $assetmap_files_ids=array();
    $assetmap_array=array();
    $assetmap_counter=0;

    for($i=0;$i<count($files);$i++){

      if(strtoupper(basename($files[$i]))=="ASSETMAP" || strtoupper(basename($files[$i]))=="ASSETMAP.XML"){

        $assetmap_array[$assetmap_counter]=$files[$i];
        $assetmap_counter++;

      } // closing if clause for assetmaps.

    }//main for assetmap



    for($i=0;$i<$assetmap_counter;$i++){

      $core_cpl_ids=array();
      $core_cpl_counter=0;
      $pkl_array=array();
      $pkl_counter=0;

      if(file_exists($assetmap_array[$i])){

        $asset_content=file_get_contents($assetmap_array[$i]);
        $assetmap_obj = rework_array_assetmap($asset_content);

        if(!isset($assetmap_obj->Id)){

          // NON è UN ASSETMAP VALIDO
          echo "INVALID ASSETMAP ".$assetmap_array[$i].PHP_EOL;
          continue;

        }

        if($assetmap_obj->getName()=="AssetMap") {

            $assetmap_xml = objectsIntoArray($assetmap_obj);

            $assetmap_files_ids["ASSETMAP_".$i]['ASSETS']['ASSETMAP']['Filename'] = $assetmap_array[$i];


            // SOVRASCRIVO LA PATHCPL LEGGENDO DAL PUNTO DELLA ROOT DELL'ASSETMAP
            $path_cpl = str_replace(basename($assetmap_array[$i]) , '' , $assetmap_array[$i]);


            for($p=0;$p<count($assetmap_xml['AssetList']['Asset']);$p++ ) {


              $assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'] = str_replace("file:///" , "" , $assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path']);
              $assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'] = str_replace("file://" , "" , $assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path']);

              // array contenente gli asset e se vi sono o meno su disco, così sappiamo se bisognerà dare errore o meno.
              $assetmap_files_ids["ASSETMAP_".$i]['ASSETS'][$p]['Filename'] = $path_cpl.$assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'];
              $assetmap_files_ids["ASSETMAP_".$i]['ASSETS'][$p]['UUID'] = $assetmap_xml['AssetList']['Asset'][$p]['Id'];

              // mi segno se è PKL
              if(isset($assetmap_xml['AssetList']['Asset'][$p]['PackingList']))
                $assetmap_files_ids["ASSETMAP_".$i]['ASSETS'][$p]['PKL'] = 'true';

              // array conversione UUID > filename
              $assetmap_files_ids["ASSETMAP_".$i]['UUID'][$assetmap_xml['AssetList']['Asset'][$p]['Id']]=$path_cpl.$assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'];

              if(!file_exists( $path_cpl.$assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'] )){

                //$assetmap_files_ids[$assetmap_counter]['MissingFiles'][$assetmap_xml['AssetList']['Asset'][$p]['Id']]=$assetmap_xml['AssetList']['Asset'][$p]['ChunkList']['Chunk']['Path'];
                $assetmap_files_ids["ASSETMAP_".$i]['ASSETS'][$p]['Status'] = "0";

              }else {

                $assetmap_files_ids["ASSETMAP_".$i]['ASSETS'][$p]['Status'] = "1";

              }

            }



          } //invalid assetmap

        }

    }

return $assetmap_files_ids;

}


function getCPLfromPKL($pathPKL , $CONVERSION_ARRAY){

  //include("check_session.php");

  $PKL_content = file_get_contents($pathPKL);
  $PKL_OBJ = simplexml_load_string($PKL_content, 'SimpleXMLElement' , LIBXML_NOBLANKS);
  $PKL_Array = objectsIntoArray($PKL_OBJ);

  $returnArray = array();
  $index_return = 0;

  //echo $pathPKL.PHP_EOL;
  if(!isset($PKL_Array['AssetList']['Asset'][0]))
    $PKL_Array['AssetList']['Asset'][0] = $PKL_Array['AssetList']['Asset'];

  for($i = 0; $i < count($PKL_Array['AssetList']['Asset']); $i++){

    // trovo gli XML nella PKL
    if( strpos( strtoupper($PKL_Array['AssetList']['Asset'][$i]['Type']) , "TEXT/XML" ) !== FALSE ){

      if(!isset( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] )){

        // L'uuid dell'asset della PKL non è nell'assetmap... ok.
        //echo "L'uuid dell'asset della PKL non è nell'assetmap... ok.".PHP_EOL;
        continue;

      }

      // Verifico che il file in questione effettivamente esista perchè nell'array di conversion questo dato non lo abbiamo.
      if( file_exists ( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] ) ){

        // testo l'xml per vedere se è effettivamente una CompositionPlaylist.
        $XML_TEST_CPL_OBJ = simplexml_load_string( file_get_contents( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] ) , 'SimpleXMLElement' , LIBXML_NOBLANKS);

        if(!isset($XML_TEST_CPL_OBJ->Id)){

          echo "INVALID CPL -> ".$CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ].PHP_EOL;

          continue;

        }



        // Verifico....
        if($XML_TEST_CPL_OBJ -> getName() == 'CompositionPlaylist'){

          // è una CPL
          $returnArray[$index_return]['UUID'] = $PKL_Array['AssetList']['Asset'][$i]['Id'];
          $returnArray[$index_return]['Filename'] = $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ];
          //$returnArray[$index_return]['Size'] = filesize($CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ]);

          // Inizializzo il vettore vuoto.... dovesse restare vuoto dopo i 2 controlli qua sotto, allora andrà sicuramente in errore...
          $returnArray[$index_return]['ANNOTATIONTEXT'] = "";


          // Verifica AnnotationText @1.3.1 x Venezia (vedi commento versione precedente....) c/o SR
          // Retifico... Prendiamo prima il ContentTitleText e poi l'AnnotationText in caso non esiste il titolo..
          if(isset($XML_TEST_CPL_OBJ->ContentTitleText)){
            // Verifico che il contentitletext sia effettivamente valido (completo con i vari settorini divisi da _ )
            if( count(explode( "_" , $XML_TEST_CPL_OBJ->ContentTitleText )) > 4 ){
              // Valido...
              $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->ContentTitleText;
            }
          }

          // Se è ancora vuoto... controllo l'AnnotationText..
          if($returnArray[$index_return]['ANNOTATIONTEXT'] === ""){

            if(isset($XML_TEST_CPL_OBJ->AnnotationText)){

              if( count(explode( "_" , $XML_TEST_CPL_OBJ->AnnotationText )) > 4){

                $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->AnnotationText;

              }

            }

          }

          // SE LA DCP NON HA TITOLI VALIDI COME QUELLA DI VENEZIA EASYDCP BLABLA...
          // Se non ho trovato titoli validi, prendo prima l'annotationtext di default se esiste altrimenti contentTitleText
          if($returnArray[$index_return]['ANNOTATIONTEXT'] === ""){

            if(isset($XML_TEST_CPL_OBJ->ContentTitleText)){
              $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->ContentTitleText;
            } else {
              if(isset($XML_TEST_CPL_OBJ->AnnotationText)){
                $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->AnnotationText;
              }
            }
          }

          // Altrimenti, la invalido....

          /*
          // Versione 1.3 pre Venezia 2020 problema con DCP CieloStellato........ c/o SR
          if(isset($XML_TEST_CPL_OBJ->AnnotationText))
            $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->AnnotationText;
          else{
            if(isset($XML_TEST_CPL_OBJ->ContentTitleText))
              $returnArray[$index_return]['ANNOTATIONTEXT'] = (string)$XML_TEST_CPL_OBJ->ContentTitleText;
            else{

              // MANCA L'ANNOTATION TEXT O CONTENTTITLETEXT

              $returnArray[$index_return]['ANNOTATIONTEXT'] = '';
            }
          }*/

          $index_return++;

        } else {

          // Non è una cpl.. sarà 100% un sottotitolo
          //echo "Not a CPL! ".$CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ].PHP_EOL;

        }


      }

    }




  }


  return $returnArray;

}





function CPL_IDCP( $CPL_UUID_FROM_PKL , $CONVERSION_ARRAY , $DESTINATION , $PKL_FILENAME , $ASSETMAP_FILENAME , $UUID_PKL , $CURRENT_FOLDER_MAP_4_PKLS ){

  //include("check_session.php");
  include(__DIR__ . "/db_connection.php");

  // prendo la variabile globale per le uuid già copiate.
  global $UUID_ALREADY_COPIED;
  global $UUID_ALREADY_COPIED_PATH;
  global $datastore_path;
  global $IS_FTP_TRANSFER;

  global $VERSION_IDCP;

  // CPL_IDCP @ v 1.0 c/o Riva Stefano

  // CLP_IDCP @ v 1.1 c/o Riva Stefano > 02/12/2019 { Ora generiamo noi l'assetmap per ogni CPL in maniera tale che l'HULA sa quali file siano necessari per l'ingest. Copiamo anche l'originale con il nome ORIGINAL_AM }

  // Funzione che, partendo da un array contenente Filename sorgente, uuid e annotation text di una CPL , l'array di conversione delle uuid dell'assetmap e la destinazione (ES: /datastore/FILM/) ,
  // Il filename della sua PKL e del suo Assetmap
  // Copia i contenuti seguendo la regola CARTELLA_PREFISSO_ANNOTATIONTEXT / *AnnotationText CPL* / Contenuti.....
  // Per ogni CPL, una cartella come sotto cartella della folder CARTELLA_PREFISSO_ANNOTATIONTEXT

  // $CURRENT_FOLDER_MAP_4_PKLS
  // Ultima variabile aggiunta alla funzione, serve per copiare nella cartella tutte le PKL di questo assetmap anche se non sono richiesti dalla CPL perchè
  // come visto con SONIC il 14/02/2020, c'è una possibilità che nel caso particolare 1 assetmap > più PKL\CPL la PKL della CPL non contenga tutti i riferimenti
  // necessari e non viene riprodotto dal BARCO.


  $FilenameCPL = $CPL_UUID_FROM_PKL['Filename'];
  $uuidCPL = $CPL_UUID_FROM_PKL['UUID'];
  $ANNOTATIONTEXT = $CPL_UUID_FROM_PKL['ANNOTATIONTEXT'];

  echo $ANNOTATIONTEXT.PHP_EOL;

  // Array per non ripetere il ciclo di copia degli asset dei reel.
  global $arrayCPLAssets;

  // PROPS è la cartella di radice del contenuto. Serve per il playout nei contenuti in Streaming
  $PROPS = $DESTINATION;

  // STARTO LA VARIABILE FALSE, DIVENTA TRUE SE HA UNA RADICE DI FOLDER E CONTROLLO OGNI FILE GIà PRESENTE IN CASO VI SIA L'MXF IN QUESTIONE
  $VERIFY_CPL_ALREADY_PRESENT = FALSE;

  // verifico se l'annotation text è vuoto o meno.
  if(!empty($ANNOTATIONTEXT)){

    // prendo la radice dell'annotationtext
    $explodeAnnotation = explode( "_" , $ANNOTATIONTEXT );


    // 07/01/2020 LittleGirls aveva una CPL con l'annotationtext maiuscolo mentre le altre no, ciò ha causato un problema di ingestazione siccome le cartelle non erano raggruppate
    // sotto la stessa props. DI CONSEGUENZA, D'ora in poi la cartella di props (RADIX) sarà sempre maiuscola.

    $RADIX = strtoupper( $explodeAnnotation[0] );

    // verifico se esiste già la cartella di radice dell'annotationtext, in caso non esista, creo la cartella
    if(!is_dir($DESTINATION."/".$RADIX))
      mkdir( $DESTINATION."/".$RADIX , 0777); // creo la folder

    //echo $DESTINATION."/".$RADIX.PHP_EOL;

    // PROPS fixato con la sua radice.
    $PROPS = $DESTINATION."/".$RADIX;

    // sistemo la destinazione con la radice. AGGIUNTO ANCHE GLI ULTIMI 5 CARATTERI DELLA UUID
    $DESTINATION = $DESTINATION . "/" . $RADIX . "/" . ($ANNOTATIONTEXT . "_" . strtolower(substr($uuidCPL , strlen($uuidCPL) - 5 , strlen($uuidCPL) ) )) . "/";

    //echo $DESTINATION.PHP_EOL;

    if( !is_dir($DESTINATION) )
      mkdir( $DESTINATION , 0777); // creo la folder del contenuto di questa CPL


      // SE ESISTE LA ROOT DELLA CARTELLA, DOVREI VERIFICARE SE IN TUTTE QUESTE CARTELLE è GIà PRESENTE UN FILE DI QUESTA CPL,
      // COSì NON VIENE RICOPIATA DI NUOVO PER PREVENIRE QUANDO UNA CPL VIENE EFFETTIVAMENTE COPIATA DOPO
      // UNA CPL GIà PRESENTE CON I FILE VIDEO \ AUDIO "CONDIVISI"



  }

  // sistemo PROPS per il database di m_dcp
  $PROPS = str_replace("//" , "/" , ($PROPS."/" ) );
  $PROPS = str_replace($datastore_path , '' , $PROPS );


  // MI carico il contenuto della CPL in un array
  $CPL_array = parseCPLContent( file_get_contents( $FilenameCPL ) );

  //print_r($CPL_array);


  // sistemo gli indici dell'array per il for
  if(!isset($CPL_array['ReelList']['Reel'][0]))
    if(isset($CPL_array['ReelList']['Reel'])){

      $CPL_array['ReelList']['Reel'][0] = $CPL_array['ReelList']['Reel'];

    } else {

      // la cpl non ha reel....
      ECHO "NO REEL!!".PHP_EOL;
      return "error_cpl";

    }


    // Levo il filename della CPL dal percorso globale della CPL, così ho il punto di riferimento della root di questa DCP per la copia e creazione di sotto cartelle dei sottotitoli
    $PREFIX_FOLDER_TO_REMOVE = str_replace( basename($FilenameCPL) , "" , $FilenameCPL );


    // ID TASK DI COPIA X IL PROCESSO DI MONITOR
    $ID_TASK = new_ID('dci_import_task' , $db);
    $SOURCE_DB = str_replace( basename($FilenameCPL) , '' , $FilenameCPL );
    $SOURCE_SIZE = get_CPL_real_SIZE( $CPL_array , $CONVERSION_ARRAY , $PKL_FILENAME , $ASSETMAP_FILENAME , $FilenameCPL , $UUID_ALREADY_COPIED , $CURRENT_FOLDER_MAP_4_PKLS, $UUID_PKL);

    // ALLA SIZE DELLA CPL, SOMMO LA SIZE DEI FONTS CHE VERRANNO COPIATI ALLA FINE PERCHè NON FANNO PARTE DELLA CPL.
    $SOURCE_SIZE = $SOURCE_SIZE + FONTS_IDCP($PKL_FILENAME , $FilenameCPL , $CONVERSION_ARRAY , $PREFIX_FOLDER_TO_REMOVE , $DESTINATION , 0 , 0);



    //exit;


    $IS_FROM_FTP = '0';

    // SE CONTIENE LA STRINGA FTP:// , VIENE DA UN FTP!
    if( $IS_FTP_TRANSFER == TRUE ){

      global $FTP_ADDRESS , $FTP_PORT , $FTP_USERNAME , $FTP_PASSWORD , $RADIX_FTP;
      $IS_FROM_FTP = '1';

    }

    // CONTROLLO SE QUESTA CPL è GIà STATA INGESTATA O MENO?? nah i tasks non devono essere uno storico legittimo 1a1 .
    mysqli_query($db,"DELETE FROM dci_import_task WHERE UuidCpl = '".$uuidCPL."'"); // cambiato idea, devo.

    // CREO IL RECORD DI QUESTO TASK
    mysqli_query($db,"INSERT INTO dci_import_task ( ID, DestinationPath, SourcePath, PID, TotalSize, Status, Completation, StartedBy, StartedAt,
     SpeedMbs, isFTP, Timestamp, LastSizeState, FilesizeInCopy, UuidCpl )
    VALUES ( \"".$ID_TASK."\" , \"".$DESTINATION."\" , \"".$SOURCE_DB."\" , '' , \"".$SOURCE_SIZE."\" ,
      \"STARTING\" , \"0\" , \"\" , \"".date('Y-m-d H:i:s')."\" , \"0\" , \"".$IS_FROM_FTP."\" , \"".date('Y-m-d H:i:s')."\" , \"0\" , \"0\", \"".$uuidCPL."\" )");


  // LANCIO IL MONITOR
  $desc=array();
  $pipes=array();
  $proc_openID = proc_open("php StreamerIDCP/streamer_idcp_monitor.php ".escapeshellarg($ID_TASK)." /dev/null 2>&1 &" ,$desc,$pipes);


  // COPIO LA CPL, ASSETMAP originale E PKL
  copy( $FilenameCPL , $DESTINATION . "/" . basename($FilenameCPL));
  copy( $PKL_FILENAME, $DESTINATION . "/" . "backup_" . basename($PKL_FILENAME));
  copy( $ASSETMAP_FILENAME, $DESTINATION . "/" . "ORIGINAL_AM");

  $ASSETMAP_OBJ = parseAssetmap(file_get_contents($ASSETMAP_FILENAME));

  if($ASSETMAP_OBJ == null){

    // NON è STATO POSSIBILE LEGGERE L'ASSETMAP
    return "error";

  }

  $namespaces = $ASSETMAP_OBJ->getNameSpaces(true);

  // setto l'xmlns di "default"
  $xmlns = "http://www.digicine.com/PROTO-ASDCP-AM-20040311#";

  if(isset($namespaces['']))
    if(!empty($namespaces['']))
      $xmlns = $namespaces['']; // setto l'xmlns dell'assetmap


  $real_uuid=UUID::v4();
  $uuid="urn:uuid:".$real_uuid;

  // creo l'header dell'assetmap nuovo
  $ASSETMAP_REMAKE = new SimpleXMLElement('<AssetMap xmlns="'.$xmlns.'"/>');

  $issuerDate = !isset($ASSETMAP_OBJ->IssueDate) ? date('c') : $ASSETMAP_OBJ->IssueDate;

  $header = $ASSETMAP_REMAKE -> addChild('Id' , $uuid);
  $header = $ASSETMAP_REMAKE -> addChild('AnnotationText' , $ANNOTATIONTEXT);
  $header = $ASSETMAP_REMAKE -> addChild('IssueDate' , $issuerDate);
  $header = $ASSETMAP_REMAKE -> addChild('Issuer' , "Bitonlive Content Management" );
  $header = $ASSETMAP_REMAKE -> addChild('Creator' , "StreamerIDCP ".$VERSION_IDCP );

  $assets = $ASSETMAP_REMAKE -> addChild('AssetList');

  $ASSETS_ADDED_IN_THIS_ASSETMAP = array();

  // AGGIUNGO CPL
  $assetmap_element = $assets -> addChild('Asset');
  // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
  $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['Id'] , basename($FilenameCPL) , 0);

  // AGGIUNGO PKL
  //$assetmap_element = $assets -> addChild('Asset');
  // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
  //$assetmap_element = generateAssetmapAsset( $assetmap_element , $UUID_PKL , basename($PKL_FILENAME) , 1);


  // CERCO LE PKL "EXTRA" A QUELLA DI QUESTA CPL E LA AGGIUNGO ALLA CARTELLA + ASSETMAP
  /*for($pklExtra = 0; $pklExtra <= count($CURRENT_FOLDER_MAP_4_PKLS); $pklExtra++){

    if(!isset($CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]))
      continue;

    // Valida, da copiare.
    if( isset($CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['PKL']) && $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Status'] == '1' && $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['UUID'] != $UUID_PKL){

      // COPIO LA PKL
      copy( $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Filename'] , $DESTINATION . "/" . basename( $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Filename'] ));

      // AGGIUNGO PKL
      $assetmap_element = $assets -> addChild('Asset');
      // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
      $assetmap_element = generateAssetmapAsset( $assetmap_element , $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['UUID'] , basename( $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Filename'] ) , 1);

    }

  }*/
  // FINE COPIA\AGGIUNTA PKL "EXTRA"


  // ciclo dei reel
  for($indexCPL = 0; $indexCPL < count($CPL_array['ReelList']['Reel']); $indexCPL++ ) {


    // Ciclo di copia x MainPicture , MainSound , MainSubtitle
    for($indexTYPE = 0; $indexTYPE < 6; $indexTYPE++){

    $CURRENT_ASSET = $arrayCPLAssets[$indexTYPE];

    //if(!isset($CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]))
      //echo "Non esiste il reel ".$CURRENT_ASSET." -> ".$FilenameCPL.PHP_EOL;

    // COPIO IL *PICTURE/SOUND/SUBTITLE*
    if(isset($CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET])){

      // Se il conversion array ci torna un filename significa che sappiamo quale sia il file necessario.
      if( isset($CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]) ){

        // riverifico la sua esistenza su disco...
        if(file_exists( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] )){


          if(isset( $UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ) ){

            // IL FILE è GIà STATO COPIATO IN UN ALTRA CARTELLA, PROBABILMENTE è DI 2 CPL DIVERSE DELLO STESSO CONTENUTO CHE PRIMA, STAVANO NELLA STESSA CARTELLA
            // ES: JurassicWorld2 che abbiamo da noi, è composto da 1 assetmap, 2 CPL e 2 PKL tutte nella stessa cartella, con questo processo vengono divise in 2 cartelle diverse
            // e alcuni file erano comuni ad entrambe le cpl, di conseguenza sarebbero stati copiati 2 volte in questo processo, mentre con questo controllo è sufficente
            // che sia in solo 1 delle due cartelle per poter essere validato e playbackato da ogni imb.

            //echo "[ALREADY COPIED] ".$CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ].PHP_EOL;

            /*if(!in_array($CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , $ASSETS_ADDED_IN_THIS_ASSETMAP)){

              echo  $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'];
              //print_r($ASSETS_ADDED_IN_THIS_ASSETMAP);

              $assetmap_element = $assets -> addChild('Asset');
              // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
              $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , "../".$UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] , 0 , true);

            }*/

            continue;

          }


          // SPEZZO IL NOME DEL FILE SCRITTO NELL'ASSETMAP SENZA LA RADICE DEL NOSTRO FILENAME PER SCOPRIRE SE è IN UNA SOTTO CARTELLA
          $EXPLODE_PATH = explode( "/" , str_replace( $PREFIX_FOLDER_TO_REMOVE , '' , $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ) );

          // Di default, il file è da copiare, viene skippato solo se già presente in destinazione con la stessa dimensione dell'originale in sorgente!
          $SKIP_COPY = FALSE;



          if($IS_FTP_TRANSFER == FALSE){

            $filesize_source = filesize( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]);

          } else {


                // MI COLLEGO IN FTP
                $FTP_CONNESSION = ftp_connect($FTP_ADDRESS , $FTP_PORT , 10);
                $login = ftp_login($FTP_CONNESSION, $FTP_USERNAME, $FTP_PASSWORD);
                ftp_set_option($FTP_CONNESSION, FTP_USEPASVADDRESS, false);
                $mode = ftp_pasv($FTP_CONNESSION, TRUE);

                // prendo il filesize in FTP
                $filesize_source = ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ));

                ftp_close($FTP_CONNESSION);


          }




          // subfolder! (100% UN SOTTOTITOLO)
          if(count($EXPLODE_PATH)>1){

            // Creo la cartella, solitamente per i sottotitoli, ma la funzione copre qualsiasi tipo di situazione
            if(!is_dir( $DESTINATION."/".$EXPLODE_PATH[0] ))
              mkdir( $DESTINATION."/".$EXPLODE_PATH[0] , 0777);

            // verifico se il file in destinazione già esista
            if(file_exists( $DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] )){

              if( filesize( $DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] ) == $filesize_source ){

                $assetmap_element = $assets -> addChild('Asset');
                // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
                $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , $EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] , 0);

                // LO SEGNO COME GIà AGGIUNTO IN QUESTO ASSETMAP.
                array_push($ASSETS_ADDED_IN_THIS_ASSETMAP , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id']);

                $UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = 'TRUE';

                $BASENAME_DESTINATION = basename($DESTINATION); // Prendo il nome della cartella della CPL che contiene il file già copiato
                // Scrivo il path interno alla props del file già copiato
                if(!isset($UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]))
                  $UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = $BASENAME_DESTINATION . "/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1];

                $SKIP_COPY = TRUE;

                continue;

              } else {

                //echo "!![SIZE NOT MATCHED] ".filesize( $DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] )." - S ".$filesize_source." @ ".$DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1].PHP_EOL;

              }


            }


            // COPIO IL FILE SE NON è DA SKIPPARE PERCHè GIà PRESENTE CON LE STESSE DIMENSIONI
            if( $SKIP_COPY == FALSE ){

              $lastSizeState = foldersize($DESTINATION);

              // Aggiorno il task per avere il filesize progress dalla parte di visualizzazione
              mysqli_query($db,"UPDATE dci_import_task SET LastSizeState = '".$lastSizeState."' , FilesizeInCopy = '".$filesize_source."' , FilenameInCopy = \"".(basename($CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]))."\" WHERE ID = '".$ID_TASK."'");

              if( copy( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] , $DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] ) ){

                // è UN SOTTOTITOLO, NON POSSO SEGNARLO GIà COPIATO!

                $assetmap_element = $assets -> addChild('Asset');
                // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
                $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , $EXPLODE_PATH[0]."/".$EXPLODE_PATH[1] , 0);

                array_push($ASSETS_ADDED_IN_THIS_ASSETMAP , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id']);

                //$UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = 'TRUE';

              }

            }

            /*
            echo "creo cartella - ".$DESTINATION."/".$EXPLODE_PATH[0].PHP_EOL;
            echo "COPIO - ".$DESTINATION."/".$EXPLODE_PATH[0]."/".$EXPLODE_PATH[1].PHP_EOL;
            */


          } else {

            //NON è UN SOTTOTIOLO! (AUDIO\VIDEO)

            // verifico se il file in destinazione già esista
            if(file_exists( $DESTINATION."/".$EXPLODE_PATH[0] )){

              if( filesize($DESTINATION."/".$EXPLODE_PATH[0] ) == $filesize_source ){

                //echo "[SIZE MATCHED] ".filesize( $DESTINATION."/".$EXPLODE_PATH[0] )." - S ".$filesize_source." @ ".$DESTINATION."/".$EXPLODE_PATH[0].PHP_EOL;

                $assetmap_element = $assets -> addChild('Asset');
                // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
                $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , $EXPLODE_PATH[0] , 0);

                // LO SEGNO COME GIà AGGIUNTO IN QUESTO ASSETMAP.
                array_push($ASSETS_ADDED_IN_THIS_ASSETMAP , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id']);

                $UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = 'TRUE';

                $BASENAME_DESTINATION = basename($DESTINATION); // Prendo il nome della cartella della CPL che contiene il file già copiato
                // Scrivo il path interno alla props del file già copiato
                if(!isset($UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]))
                  $UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = $BASENAME_DESTINATION . "/".$EXPLODE_PATH[0];

                $SKIP_COPY = TRUE;

              } else {

                //echo "!![SIZE NOT MATCHED] ".filesize( $DESTINATION."/".$EXPLODE_PATH[0] )." - S ".$filesize_source." @ ".$DESTINATION."/".$EXPLODE_PATH[0].PHP_EOL;

              }


            }

            // COPIO IL FILE SE NON è DA SKIPPARE PERCHè GIà PRESENTE CON LE STESSE DIMENSIONI
            if( $SKIP_COPY == FALSE ){

              $lastSizeState = foldersize($DESTINATION);

              // Aggiorno il task per avere il filesize progress dalla parte di visualizzazione
              if(! mysqli_query($db,"UPDATE dci_import_task SET LastSizeState = '".$lastSizeState."' , FilesizeInCopy = '".$filesize_source."' , FilenameInCopy = \"".(basename($CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]))."\" WHERE ID = '".$ID_TASK."'")){

                // errore update???

              }

              if( copy( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] , $DESTINATION."/".$EXPLODE_PATH[0] ) ){

                // SEGNO CHE LA UUID è STATA COPIATA PRECEDENTEMENTE, COSì DA POTERLA CONTROLLARE DOPO SOLO SE NON è .XML \ .TTF

                $assetmap_element = $assets -> addChild('Asset');
                // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
                $assetmap_element = generateAssetmapAsset( $assetmap_element , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] , $EXPLODE_PATH[0] , 0);

                // LO SEGNO COME GIà AGGIUNTO IN QUESTO ASSETMAP.
                array_push($ASSETS_ADDED_IN_THIS_ASSETMAP , $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id']);

                $UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = 'TRUE';

                $BASENAME_DESTINATION = basename($DESTINATION); // Prendo il nome della cartella della CPL che contiene il file già copiato

                // Scrivo il path interno alla props del file già copiato
                if(!isset(  $UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]))
                  $UUID_ALREADY_COPIED_PATH[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = $BASENAME_DESTINATION . "/".$EXPLODE_PATH[0];



              }

            }

            //echo "COPIO - ".$DESTINATION."/".$EXPLODE_PATH[0].PHP_EOL;


          }

        }

      }

    } // FINE MAIN *PICTURE/SOUND/SUBTITLE*


    }


  }

  // COPIO I FONT CHE NON SONO NELLA CPL MA NELLA PKL E ASSETMAP. Li leggo dalla PKL per comodità identificandoli con application/ttf nel type
  $fonts_result = FONTS_IDCP($PKL_FILENAME , $FilenameCPL , $CONVERSION_ARRAY , $PREFIX_FOLDER_TO_REMOVE , $DESTINATION , 1 , $assets);

  //print_r($ASSETS_ADDED_IN_THIS_ASSETMAP);

  $assets = $fonts_result['assets'];
  $ASSETS_ADDED_IN_THIS_ASSETMAP = array_merge($ASSETS_ADDED_IN_THIS_ASSETMAP , $fonts_result['assets_id']);

  // Costruisco la PKL
  $PKL_REWORKED = buildPKLfromAssets($PKL_FILENAME , $ASSETS_ADDED_IN_THIS_ASSETMAP , $uuidCPL);

  $assetmap_element = $assets -> addChild('Asset');
  // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
  $assetmap_element = generateAssetmapAsset( $assetmap_element , $UUID_PKL , basename($PKL_FILENAME) , 1);
  file_put_contents($DESTINATION . "/" . basename($PKL_FILENAME) , $PKL_REWORKED ); // Scrivo la nuova PKL

  // scrivo l'assetmap nuovo...
  //copy( $ASSETMAP_FILENAME, $DESTINATION . "/" . "ORIGINAL_AM");
  file_put_contents( $DESTINATION . "/ASSETMAP" , $ASSETMAP_REMAKE->asXml());

  // AGGIORNO IL TOTAL DEL PROCESS CON QUESTO ASSETMAP NUOVO
  $SIZE_NEW_ASSETMAP = filesize($DESTINATION . "/ASSETMAP");
  mysqli_query($db,"UPDATE dci_import_task SET TotalSize = (TotalSize + ".$SIZE_NEW_ASSETMAP.") WHERE ID = '".$ID_TASK."'");




  // VERIFICO SE IL PROCESSO DI MONITOR ABBIA GIà RESO COMPLETE, ALTIRMENTO LO METTO IO

  // Uccido il monitor
  proc_close($proc_openID);

  $check_task = mysqli_query( $db , "SELECT * FROM dci_import_task WHERE ID = '".$ID_TASK."'" );
  $assocTask = mysqli_fetch_assoc($check_task);

  if( $assocTask['Status'] != 'COMPLETE' ){

    // foldersize della cartella di destinazione
    $filesize_datastore = foldersize( $DESTINATION );

    if($filesize_datastore >= $assocTask['TotalSize']){

      // Complete
      mysqli_query($db,"UPDATE dci_import_task SET Status = 'COMPLETE' , Completation = '".$filesize_datastore."' WHERE ID = '".$ID_TASK."'");
      mysqli_query($db, "UPDATE m_dcp SET RefrainMixIn = '0' WHERE FileAudio = '".$uuidCPL."'"); // La rendo OK

      handleVerifyDatastore($uuidCPL);


    } else {

      // Error
      mysqli_query($db,"UPDATE dci_import_task SET Status = 'ERROR' , Completation = '".$filesize_datastore."' WHERE ID = '".$ID_TASK."'");
      return true;

    }

  } else {

    // devo effettuare il link
    mysqli_query($db, "UPDATE m_dcp SET RefrainMixIn = '0' WHERE FileAudio = '".$uuidCPL."'"); // La rendo OK
    handleVerifyDatastore($uuidCPL);


  }


  return true;

}

function handleVerifyDatastore($uuidCPL){

  include(__DIR__ . "/db_connection.php");

  // metto il contenuto in verify per i datastore configurati
  mysqli_query($db, "DELETE FROM m_streamercopy_verify WHERE uuid = '".$uuidCPL."'");

  $get = mysqli_query($db, "SELECT * FROM m_datastores ORDER BY ID");
  $get_cpl = mysqli_query($db, "SELECT * FROM m_dcp WHERE Fileaudio = '".$uuidCPL."'");

  if(mysqli_num_rows($get_cpl) === 0) return false; // La CPL non è nel database???? wtf

  $assoc_cpl = mysqli_fetch_assoc($get_cpl);

  while($row = mysqli_fetch_assoc($get)){

    mysqli_query($db, "INSERT INTO m_streamercop_verify (uuid, id_cpl, progress, verify_status, folder, filename, error, datefrom, datastore_name, queued, modifydate, title)
    VALUES ('".$uuidCPL."' , '".$assoc_cpl['ID']."' , 'TOVERIFY' , '' , '".$assoc_cpl['Filename']."' , '".$assoc_cpl['String20']."' , 0, '".date('Y-m-d H:i:s')."' , '".$row['name']."' , 0 ,
     '".date('Y-m-d H:i:s')."' , '".$assoc_cpl['Title']."')");

  }

  return true;  

}

function buildPKLfromAssets($pkl_path , $uuid_current_asset , $uuidCPL){

  global $UUID_ALREADY_COPIED_PATH;
  global $VERSION_IDCP;

  $pkl_content = file_get_contents($pkl_path);

  $xml_parsed = preg_replace("/<\w[a-zA-Z0-9_-]*:/" , "<" , $pkl_content);
  $xml_parsed = preg_replace("/<\/\w[a-zA-Z0-9_-]*:/" , "</" , $xml_parsed);


  $xmlObj = simplexml_load_string($xml_parsed , 'SimpleXMLElement' , LIBXML_DTDATTR );
  $PKL_array = objectsIntoArray($xmlObj);

  $xmlns = "http://www.digicine.com/PROTO-ASDCP-PKL-20040311#";

  $PKL_REMAKE = new SimpleXMLElement('<PackingList xmlns="'.$xmlns.'"/>');

  $issuerDate = !isset($PKL_array['IssueDate']) ? (string)date('c') : (string)$PKL_array['IssueDate'];

  $header = $PKL_REMAKE -> addChild('Id' , $PKL_array['Id']);
  $header = $PKL_REMAKE -> addChild('AnnotationText' , $PKL_array['AnnotationText']);
  $header = $PKL_REMAKE -> addChild('IssueDate' , $issuerDate);
  $header = $PKL_REMAKE -> addChild('Issuer' , "Bitonlive Content Management" );
  $header = $PKL_REMAKE -> addChild('Creator' , "StreamerIDCP ".$VERSION_IDCP );
  $assets = $PKL_REMAKE -> addChild('AssetList');
  //$ASSETS_ADDED_IN_THIS_ASSETMAP = array();

  for($i = 0; $i < count($PKL_array['AssetList']['Asset']); $i++){

    $value = $PKL_array['AssetList']['Asset'][$i];

    // Se l'elemento non fa parte di questo assetmap lo scarto a meno che non sia la CPL in questione. Se è un font, lo aggiungo.
    if(!in_array($value['Id'] , $uuid_current_asset) && $value['Id'] != $uuidCPL ) continue; // Skippo, non fa parte di questo assetmap

    //if(strpos($value['Type'] , "ttf") !== false) print_r($value);

    //print_r($value);

    $asset = $assets -> addChild('Asset');
    $elem = $asset -> addChild('Id' , $value['Id']);
    $elem = $asset -> addChild('Size' , $value['Size']);
    $elem = $asset -> addChild('Type' , $value['Type']);

    if(isset($value['Hash']))
      $elem = $asset -> addChild('Hash' , $value['Hash']);

    if(isset($value['OriginalFileName']))
      $elem = $asset -> addChild('OriginalFileName' , $value['OriginalFileName']);

  }

  if(strpos($pkl_content , "<Signer") !== false){

  $pkl_og_signer = strpos($pkl_content , "<Signer");
  $signer_block = substr($pkl_content, ($pkl_og_signer), strlen($pkl_content) );

  $pos_end_signer = strpos($signer_block , "</PackingList>");
  $signer_block = substr($signer_block , 0, $pos_end_signer);

  $XMLREMAKE = (string)$PKL_REMAKE->asXml();
  $pos_end_remake = strpos($XMLREMAKE , "</PackingList>");
  $newXML = substr($XMLREMAKE , 0, $pos_end_remake);

  // Unisco pkl e signer......
  $newXML = $newXML . $signer_block . "</PackingList>";

  return $newXML;

  } else {

    return (string)$PKL_REMAKE->asXml();

  }

}

function get_CPL_real_SIZE( $CPL_array , $CONVERSION_ARRAY , $PKL_FILENAME , $ASSETMAP_FILENAME , $CPL_FILENAME , $UUID_ALREADY_COPIED , $CURRENT_FOLDER_MAP_4_PKLS, $UUID_PKL){

  // Funzione che calcola il size SOLO dei contenuti di ( Questa CPL - Contenuti già copiati che fanno parte anche di questa)
  //global $UUID_ALREADY_COPIED;
  global $arrayCPLAssets;
  global $IS_FTP_TRANSFER;
  global $FTP_CONNESSION;
  global $RADIX_FTP;


  // ARRAY DI CONTROLLO CHE SI SEGNA I FILE GIà CALCOLATI NELLA COPIA
  $ARRAY_CHECK_SUM = array();


  if($IS_FTP_TRANSFER == TRUE){

    global $FTP_ADDRESS , $FTP_PORT , $FTP_USERNAME , $FTP_PASSWORD;

    $FTP_CONNESSION = ftp_connect($FTP_ADDRESS , $FTP_PORT , 10);
    $login = ftp_login($FTP_CONNESSION, $FTP_USERNAME, $FTP_PASSWORD);
    ftp_set_option($FTP_CONNESSION, FTP_USEPASVADDRESS, false);
    $mode = ftp_pasv($FTP_CONNESSION, TRUE);

  }



  $total_size = 0;

  for( $indexCPL = 0; $indexCPL < count($CPL_array['ReelList']['Reel']); $indexCPL++ ){

    // Ciclo di copia x MainPicture , MainSound , MainSubtitle
    for($indexTYPE = 0; $indexTYPE < 6; $indexTYPE++){

    $CURRENT_ASSET = $arrayCPLAssets[$indexTYPE];

    // COPIO IL *PICTURE/SOUND/SUBTITLE*
    if(isset($CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET])){

      // Se il conversion array ci torna un filename significa che sappiamo quale sia il file necessario.
      if( isset($CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]) ){

        // riverifico la sua esistenza su disco...
        if(file_exists( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] )){


          if(isset( $UUID_ALREADY_COPIED[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ) ){

            // IL FILE è GIà STATO COPIATO IN UN ALTRA CARTELLA, PROBABILMENTE è DI 2 CPL DIVERSE DELLO STESSO CONTENUTO CHE PRIMA, STAVANO NELLA STESSA CARTELLA
            // ES: JurassicWorld2 che abbiamo da noi, è composto da 1 assetmap, 2 CPL e 2 PKL tutte nella stessa cartella, con questo processo vengono divise in 2 cartelle diverse
            // e alcuni file erano comuni ad entrambe le cpl, di conseguenza sarebbero stati copiati 2 volte in questo processo, mentre con questo controllo è sufficente
            // che sia in solo 1 delle due cartelle per poter essere validato e playbackato da ogni imb.
            // DILEMMA 14/02/2020: Mega dubbio su SONIC che richiedeva tutte le PKL disponibili o almeno, quelle su alcuni mfx nella folder IT_XX_IT che ha creato questo dubbio
            // Il problema dunque resta e attualmente dalla v 1.3, nel caso 1 assetmap / + CPL\PKL, le PKL vengono copiate in tutte le folder, you never know.

            //echo "[ALREADY COPY] ".$CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ].PHP_EOL;

            continue;

          }


          // CONTROLLO SE IL FILE è GIà STATO VERIFICATO IN CASO COMPAIA IN PIù REEL
          if(isset( $ARRAY_CHECK_SUM[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ) ){

            //echo "[ALREADY SUMMED] ".$CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ].PHP_EOL;
            continue;

          }


          //ECHO "[FILESIZE] ".$CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]." -> ".filesize( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ).PHP_EOL;
          if($IS_FTP_TRANSFER == TRUE){

            $current_size = ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ));
            //$total_size +=

          } else {

            $current_size = filesize( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] );

          }

          //ECHO "[FILESIZE] ".$CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]." -> ".$current_size.PHP_EOL;
          $total_size += intval($current_size);


          // LO SEGNO COME GIà CALCOLATO
          $ARRAY_CHECK_SUM[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] = 'TRUE';




        }

      }

    }

  }

  }

  // SOMMO LA PKL , ASSETMAP E DELLA CPL STESSA CHE NON SONO NELLA CPL!

  if($IS_FTP_TRANSFER == FALSE){

    $total_size += intval( filesize( $PKL_FILENAME ) );
    $total_size += intval( filesize( $ASSETMAP_FILENAME ) );
    $total_size += intval( filesize( $CPL_FILENAME ) );

  } else {

    $total_size += ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $PKL_FILENAME ));
    $total_size += ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $ASSETMAP_FILENAME ));
    $total_size += ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $CPL_FILENAME ));

  }


  // CERCO LE PKL "EXTRA" A QUELLA DI QUESTA CPL E LE SOMMO PER LA COPIA
  /*for($pklExtra = 0; $pklExtra <= count($CURRENT_FOLDER_MAP_4_PKLS); $pklExtra++){

    if(!isset($CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]))
      continue;

    // Valida, da copiare.
    if( isset($CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['PKL']) && $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Status'] == '1' && $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['UUID'] != $UUID_PKL){

        if($IS_FTP_TRANSFER == FALSE){

          $total_size += intval( filesize( $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Filename'] ) );

        } else {

          $total_size += ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $CURRENT_FOLDER_MAP_4_PKLS[$pklExtra]['Filename'] ));

        }

    }

  }*/
  // FINE AGGIUNTA PKL "EXTRA"

  ECHO "TOTAL => ".$total_size;

  // SE FTP CHIUDO LA CONNESSIONE
  if($IS_FTP_TRANSFER == TRUE){

    ftp_close($FTP_CONNESSION);

  }

  return $total_size;

}



function FONTS_IDCP($PKL_FILENAME , $CPL_FILENAME , $CONVERSION_ARRAY , $PREFIX_FOLDER_TO_REMOVE , $DESTINATION , $MODE , $assets){

  // MODE: 0 = Ritorno il filesize dei font , 1 = Li copio nella destination.

  global $IS_FTP_TRANSFER;
  global $RADIX_FTP;
  global $arrayCPLAssets;

  $SIZE_RETURN = 0;
  $current_assets = array();

  $xmlObj = simplexml_load_string( file_get_contents($PKL_FILENAME) , 'SimpleXMLElement' , LIBXML_NOBLANKS);
  $PKL_Array = objectsIntoArray($xmlObj);

  $CPL_array = parseCPLContent( file_get_contents($CPL_FILENAME) );

  // SE è FTP E MI SERVE IL FILESIZE MI COLLEGO
  if($MODE == 0 && $IS_FTP_TRANSFER == TRUE){

    global $FTP_ADDRESS , $FTP_PORT , $FTP_USERNAME , $FTP_PASSWORD;

    $FTP_CONNESSION = ftp_connect($FTP_ADDRESS , $FTP_PORT , 10);
    $login = ftp_login($FTP_CONNESSION, $FTP_USERNAME, $FTP_PASSWORD);
    ftp_set_option($FTP_CONNESSION, FTP_USEPASVADDRESS, false);
    $mode = ftp_pasv($FTP_CONNESSION, TRUE);

  }

  // Sistemo l'order della CPL
  if(!isset($CPL_array['ReelList']['Reel'][0]))
    $CPL_array['ReelList']['Reel'][0] = $CPL_array['ReelList']['Reel'];

  $ARRAY_FOLDERS_FONTS = array();

  for( $indexCPL = 0; $indexCPL < count($CPL_array['ReelList']['Reel']); $indexCPL++ ){

    // Passo solo i sottotitoli
    $indexTYPE = 2;
    $CURRENT_ASSET = $arrayCPLAssets[$indexTYPE];

    // verifico che esista il sottotitolo
    if(isset($CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET])){

      $ONLY_FOLDER = str_replace( basename( $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ] ) , '' , $CONVERSION_ARRAY[ $CPL_array['ReelList']['Reel'][$indexCPL]['AssetList'][$CURRENT_ASSET]['Id'] ]);
      $ONLY_FOLDER = str_replace( basename($CPL_FILENAME) , '' , $ONLY_FOLDER );

      $ARRAY_FOLDERS_FONTS[$ONLY_FOLDER] = 'TRUE';

    }



  }



  for($i = 0; $i < count($PKL_Array['AssetList']['Asset']); $i++){

    // trovo I FONT nella PKL
    if( strpos( strtoupper($PKL_Array['AssetList']['Asset'][$i]['Type']) , "APPLICATION/TTF" ) !== FALSE ){

      if(!isset( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] )){

        // L'uuid dell'asset della PKL non è nell'assetmap... ok.
        //echo "L'uuid dell'asset della PKL non è nell'assetmap... ok.".PHP_EOL;
        continue;

      }

      $CHECK_FOLDER = str_replace( basename( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] ) , '' , $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] );
      $CHECK_FOLDER = str_replace( basename( $CPL_FILENAME ) , '' , $CHECK_FOLDER );

      if(!isset($ARRAY_FOLDERS_FONTS[$CHECK_FOLDER])){

        // Se non esiste la cartella del sottotitolo di questa CPL, non serve calcolare\copiare il font altrimenti va in errore e sballa il size.
        continue;

      }


      // Verifico che il file in questione effettivamente esista perchè nell'array di conversion questo dato non lo abbiamo.
      //if( file_exists ( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] ) ){

        // SE LA MODE è 0, SOMMO IL SUO SIZE
        if($MODE == 0){

          if($IS_FTP_TRANSFER == TRUE){

            $SIZE_RETURN += ftp_size($FTP_CONNESSION , str_replace( $RADIX_FTP , '' , $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] ));

          } else {

            $SIZE_RETURN += filesize( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] );

          }

        } else {

          // DEVO CONTROLLARE SE ESISTE O MENO LA CARTELLA DEI SOTTOTITOLI DI RIFERIMENTO

          $OG_PATH = str_replace( $PREFIX_FOLDER_TO_REMOVE , '' , $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] );
          // COPIO IL FONT fregandomene del "è già stato copiato una volta".
          if( copy( $CONVERSION_ARRAY[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] , $DESTINATION . "/" . $OG_PATH ) ){


            $assetmap_element = $assets -> addChild('Asset');
            // la funzione richiede l'elemento xml dell'assetmap, l'uuid dell'elemento da aggiungere e il suo filename per la path.
            $assetmap_element = generateAssetmapAsset( $assetmap_element , $PKL_Array['AssetList']['Asset'][$i]['Id'] , $OG_PATH , 0 );

            array_push($current_assets , $PKL_Array['AssetList']['Asset'][$i]['Id']);

            // lo segno già copiato.
            //$UUID_ALREADY_COPIED[ $PKL_Array['AssetList']['Asset'][$i]['Id'] ] = 'TRUE';

          }

        }

      //}

    }

  }


  if($MODE == 0 && $IS_FTP_TRANSFER == TRUE){

    ftp_close($FTP_CONNESSION);

  }

  if($MODE == 0){

    return $SIZE_RETURN;

  }

  //print_r($current_assets);
  return array( "assets" => $assets , "assets_id" => $current_assets);

}


function generateAssetmapAsset($assetmap_element , $uuid , $filename , $IS_PKL, $ignore_tag = false){

  // CREO L'ASSET

  $temp_asset = $assetmap_element -> addChild('Id' , $uuid ); // ID DEL FILE DALL'ASSETMAP ORIGINALE

  if($IS_PKL == 1){

    $pkl_asset = $assetmap_element -> addChild('PackingList' , 'true');

  }

  $chunklist = $assetmap_element -> addChild('ChunkList'); // CHUNKLIST
  $chunkobj = $chunklist -> addChild('Chunk');
  $chunk = $chunkobj -> addChild('Path' , $filename ); // FILENAME DEL FILE
  $chunk = $chunkobj -> addChild('VolumeIndex' , '1' ); // Non ho idea di cosa sia ma è in tutti gli assetmap.....

  if($ignore_tag) $chunk = $chunkobj -> addChild('IdcpIgnore' , '1' ); // Non ho idea di cosa sia ma è in tutti gli assetmap.....

  return $assetmap_element;

  // FINE CREAZIONE ASSET

}


// FUNZIONI DI utility


function parseCPLContent($xml){


    // REGEX PER TOGLIERE QUALSIASI NODO : CAMPO
    /*<\w[a-zA-Z0-9_-]*:|</\w[a-zA-Z0-9_-]*:*/

    $xml_parsed = preg_replace("/<\w[a-zA-Z0-9_-]*:/" , "<" , $xml);
    $xml_parsed = preg_replace("/<\/\w[a-zA-Z0-9_-]*:/" , "</" , $xml_parsed);


    //$xml_parsed = str_replace('sicpl:' , '' , $xml);
    //$xml_parsed = str_replace('msp-cpl:' , '' , $xml_parsed);
    //$xml_parsed = str_replace('axd-cpl:' , '' , $xml_parsed);
    //$xml_parsed = str_replace('xmlns:axd-cpl="http://www.dolby.com/schemas/2012/AD"' , '' , $xml_parsed);
    //$xml_parsed = str_replace('ns1:' , '' , $xml_parsed);

    $xmlObj = simplexml_load_string($xml_parsed, 'SimpleXMLElement' , LIBXML_NOBLANKS);
    $XML_CPL = objectsIntoArray($xmlObj);

    return $XML_CPL;

}


function rework_array_assetmap($xml){

  $xml_parsed = str_replace('am:' , '' , $xml);
  $xmlObj = simplexml_load_string($xml_parsed, 'SimpleXMLElement' , LIBXML_NOBLANKS);
  //$xmlfixed = objectsIntoArray($xmlObj);

  return $xmlObj;

}


function getDirContents($dir, &$results = array()){

    $files = scandir($dir);

    //echo $dir;

    foreach($files as $key => $value){
        //$path = realpath($dir.DIRECTORY_SEPARATOR.$value);

        $path = $dir."/".$value;

        if(!is_dir($path)) {
            $results[] = $path;
        } else if($value != "." && $value != "..") {
            getDirContents($path, $results);
            $results[] = $path;
        }
    }

    return $results;
}



function objectsIntoArray($arrObjData, $arrSkipIndices = array())
{
    $arrData = array();

    // if input is object, convert into array
    if (is_object($arrObjData)) {
        $arrObjData = get_object_vars($arrObjData);
    }

    if (is_array($arrObjData)) {

        foreach ($arrObjData as $index => $value) {
            //$index=remove_dots($index);

            if (is_object($value) || is_array($value)) {
                $value = objectsIntoArray($value, $arrSkipIndices); // recursive call
            }

            if (in_array($index, $arrSkipIndices)) {
                continue;
            }
            $arrData[$index] = $value;
        }
    }
    return $arrData;
}

function foldersize($path) {
    $total_size = 0;
    $files = scandir($path);
    $cleanPath = rtrim($path, '/'). '/';

    foreach($files as $t) {
        if ($t<>"." && $t<>"..") {
            $currentFile = $cleanPath . $t;
            if (is_dir($currentFile)) {
                $size = foldersize($currentFile);
                $total_size += $size;
            }
            else {
                $size = filesize($currentFile);
                $total_size += $size;
            }
        }
    }

    return $total_size;

}

function new_ID($tablename , $db){

    $check_ids=mysqli_query($db,"SELECT * FROM ".$tablename);
    if(mysqli_num_rows($check_ids)==0)
      return 1;
    $query_id=mysqli_query($db,"SELECT ID FROM ".$tablename." WHERE ID=(SELECT MAX(ID) FROM ".$tablename.")");
    while($id_p=mysqli_fetch_array($query_id)){
      $id_max=$id_p['ID'];}
    $newid=intval($id_max+1);
    return $newid;
}


function parseAssetmap($xml){

  $xml_parsed = str_replace('am:' , '' , $xml);

  //$xml_parsed=$xml_parsed."</sandbox>";

  $xmlObj = simplexml_load_string($xml_parsed, 'SimpleXMLElement' , LIBXML_DTDATTR );


  if(!isset($xmlObj->Id)){

    echo "ERROR2";

  }

  if($xmlObj->getName()!="AssetMap")
    return null;



  return $xmlObj;

}

?>
