<?php

    $credentials=json_decode((string)base64_decode($_SERVER['argv'][1]));

    $db = mysqli_connect($credentials->address , $credentials->username, $credentials->password); // Connetto
    if(!mysqli_select_db($db, $credentials->schema)){

        // Creo il database\schema
        mysqli_query($db,"CREATE DATABASE `".$credentials->schema."`");
        if(!mysqli_select_db($db, $credentials->schema)){
            return false; // Non siamo riusciti a crearlo e\o selezionarlo... not good
        }

    } // Apro il db

    

    /*======================*/
    /* Inizio il controllo */
    /*======================*/
    
    $table = "clips";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'uuid', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'filename', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'folder', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'ingested', $table, 'tinyint(2) NOT NULL DEFAULT 0');
        checkDBField($db,'todelete', $table, 'tinyint(2) NOT NULL DEFAULT 0');
        checkDBField($db,'task', $table, 'varchar(256) NOT NULL DEFAULT ""');
        checkDBField($db,'error', $table, 'int(11) NOT NULL DEFAULT 0');
        checkDBField($db,'serial', $table, 'varchar(256) DEFAULT NULL');
        checkDBField($db,'datefrom', $table, 'varchar(256) DEFAULT NULL');
        checkDBField($db,'queued', $table, 'int(11) NOT NULL DEFAULT 0');
        checkDBField($db,'dcpid', $table, 'int(11) NOT NULL DEFAULT 0');
        checkDBField($db,'modifydate', $table, 'datetime NOT NULL DEFAULT CURRENT_TIMESTAMP');
        checkDBField($db,'title', $table, 'varchar(256) NOT NULL DEFAULT ""');
        checkDBField($db,'description', $table, 'text');
        checkDBField($db,'progress_perc', $table, 'int(10) unsigned DEFAULT NULL');
        checkDBField($db,'assets', $table, 'longtext');
        
 
    } else {

        mysqli_query($db, "CREATE TABLE `clips` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `uuid` varchar(256) NOT NULL,
          `filename` varchar(256) DEFAULT NULL,
          `folder` varchar(256) NOT NULL,
          `ingested` int(11) NOT NULL DEFAULT '0',
          `todelete` int(11) NOT NULL DEFAULT '0',
          `progress` varchar(256) NOT NULL DEFAULT '',
          `task` varchar(256) NOT NULL DEFAULT '',
          `error` int(11) NOT NULL DEFAULT '0',
          `serial` varchar(256) DEFAULT NULL,
          `datefrom` varchar(256) DEFAULT NULL,
          `queued` int(11) NOT NULL DEFAULT '0',
          `dcpid` varchar(100) DEFAULT NULL,
          `modifydate` datetime NOT NULL DEFAULT '2000-01-01 00:00:00',
          `title` varchar(256) NOT NULL,
          `description` text,
          `progress_perc` int(10) unsigned DEFAULT NULL,
          `assets` longtext,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "dci_import_task";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'DestinationPath', $table, 'varchar(255) NOT NULL');
        checkDBField($db,'SourcePath', $table, 'varchar(255) NOT NULL');
        checkDBField($db,'PID', $table, 'varchar(255) NOT NULL');
        checkDBField($db,'TotalSize', $table, 'bigint(20) unsigned NOT NULL DEFAULT 0');
        checkDBField($db,'Status', $table, 'varchar(45) NOT NULL DEFAULT "PROCESSING"');
        checkDBField($db,'Completation', $table, 'bigint(20) unsigned NOT NULL DEFAULT 0');
        checkDBField($db,'StartedBy', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'StartedAt', $table, 'datetime DEFAULT NULL');
        checkDBField($db,'SpeedMbs', $table, 'bigint(20) unsigned DEFAULT 0');
        checkDBField($db,'isFTP', $table, 'tinyint(1) DEFAULT 0');
        checkDBField($db,'Timestamp', $table, 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP');
        checkDBField($db,'LastSizeState', $table, 'bigint(20) unsigned DEFAULT 0');
        checkDBField($db,'FilesizeInCopy', $table, 'bigint(20) unsigned DEFAULT 0');
        checkDBField($db,'FilenameInCopy', $table, 'varchar(120) DEFAULT NULL');
        checkDBField($db,'UuidCpl', $table, 'varchar(255) DEFAULT NULL');

    } else {

        mysqli_query($db,"CREATE TABLE  `dci_import_task` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `DestinationPath` varchar(255) NOT NULL,
          `SourcePath` varchar(255) NOT NULL,
          `PID` varchar(255) NOT NULL,
          `TotalSize` bigint(20) unsigned NOT NULL DEFAULT '0',
          `Status` varchar(45) NOT NULL DEFAULT 'PROCESSING',
          `Completation` bigint(20) unsigned NOT NULL DEFAULT '0',
          `StartedBy` varchar(45) DEFAULT NULL,
          `StartedAt` datetime DEFAULT NULL,
          `SpeedMbs` bigint(20) unsigned DEFAULT '0',
          `isFTP` tinyint(1) DEFAULT '0',
          `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          `LastSizeState` bigint(20) unsigned DEFAULT '0',
          `FilesizeInCopy` bigint(20) unsigned DEFAULT '0',
          `FilenameInCopy` varchar(120) DEFAULT NULL,
          `UuidCpl` varchar(255) DEFAULT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    $table = "kdm";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'filename', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'folder', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'serial', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'projectorid', $table, 'varchar(100) NOT NULL');
        checkDBField($db,'startdate', $table, 'varchar(100) NOT NULL');
        checkDBField($db,'enddate', $table, 'varchar(100) NOT NULL');
        checkDBField($db,'ingested', $table, 'TINYINT(2) NOT NULL DEFAULT 0');
        checkDBField($db,'todelete', $table, 'TINYINT(2) NOT NULL DEFAULT 0');
        checkDBField($db,'progress', $table, 'varchar(100) NOT NULL');
        checkDBField($db,'task', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'error', $table, 'INT(11) NOT NULL DEFAULT 0');
        checkDBField($db,'uuid', $table, 'varchar(256) NOT NULL');
        checkDBField($db,'modifydate', $table, 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP');
        checkDBField($db,'description', $table, 'varchar(500) DEFAULT NULL');
        checkDBField($db,'id_kdm', $table, 'varchar(100) DEFAULT NULL');

    } else {

        mysqli_query($db, "CREATE TABLE  `kdm` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `filename` varchar(256) NOT NULL,
          `folder` varchar(256) NOT NULL,
          `serial` varchar(256) NOT NULL,
          `projectorid` varchar(100) DEFAULT NULL,
          `startdate` text,
          `enddate` text,
          `ingested` int(11) NOT NULL DEFAULT '0',
          `todelete` int(11) DEFAULT '0',
          `progress` varchar(256) NOT NULL DEFAULT '0',
          `task` varchar(256) NOT NULL DEFAULT '',
          `error` int(11) NOT NULL DEFAULT '0',
          `uuid` varchar(256) NOT NULL,
          `modifydate` datetime NOT NULL DEFAULT '2000-01-01 00:00:00',
          `description` varchar(500) DEFAULT NULL,
          `id_kdm` varchar(256) DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    $table = "m_audioprocessor";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'address', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'port', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'serial', $table, 'varchar(65) DEFAULT NULL');
        checkDBField($db,'kdm_serial', $table, 'varchar(65) DEFAULT NULL');
        checkDBField($db,'type', $table, 'int(10) unsigned NOT NULL DEFAULT 0');

    } else {

        mysqli_query($db, "CREATE TABLE `m_audioprocessor` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `address` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `serial` varchar(65) DEFAULT NULL,
          `kdm_serial` varchar(65) DEFAULT NULL,
          `type` int(10) unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    $table = "m_automation";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'Channel', $table, 'varchar(7) DEFAULT ""');
        checkDBField($db,'Name', $table, 'varchar(50) DEFAULT ""');
        checkDBField($db,'Groupname', $table, 'varchar(30) DEFAULT ""');
        checkDBField($db,'Category', $table, 'varchar(30) DEFAULT ""');
        checkDBField($db,'Value', $table, 'varchar(45) NOT NULL DEFAULT 0');

    } else {

        mysqli_query($db, "CREATE TABLE `m_automation` (
          `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
          `Channel` varchar(7) DEFAULT '',
          `Name` varchar(50) DEFAULT '',
          `Groupname` varchar(30) DEFAULT '',
          `Category` varchar(30) DEFAULT '',
          `Value` varchar(45) NOT NULL DEFAULT '0',
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }
    
    $table = "m_category_images";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'Name', $table, 'varchar(45) NOT NULL DEFAULT ""');
        checkDBField($db,'Image', $table, 'longtext NOT NULL');
        checkDBField($db,'is_clips', $table, 'tinyint(1) NOT NULL DEFAULT 0');

    } else {

        mysqli_query($db,"CREATE TABLE `m_category_images` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `Name` varchar(45) NOT NULL DEFAULT '',
          `Image` longtext NOT NULL,
          `is_clips` tinyint(1) NOT NULL DEFAULT '0',
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_cinestream_active_apps";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'id_user', $table, 'int(10) unsigned NOT NULL DEFAULT 0');
        checkDBField($db,'id_table_app', $table, 'int(10) unsigned NOT NULL DEFAULT 0');
        checkDBField($db,'options', $table, 'text NOT NULL');

    } else {

        mysqli_query($db, "CREATE TABLE  `m_cinestream_active_apps` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `id_user` int(10) unsigned NOT NULL DEFAULT '0',
          `id_table_app` int(10) unsigned NOT NULL DEFAULT '0',
          `options` text NOT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_cinestream_bookings";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'id_user', $table, 'int(10) unsigned NOT NULL DEFAULT 0');
        checkDBField($db,'valid_from', $table, 'datetime DEFAULT NULL');
        checkDBField($db,'valid_to', $table, 'datetime DEFAULT NULL');
        checkDBField($db,'username', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'password', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'timestamp', $table, 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP');
        checkDBField($db,'customer_fullname', $table, 'varchar(75) DEFAULT NULL');
        checkDBField($db,'phone', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'cancelled', $table, 'tinyint(1) NOT NULL DEFAULT 0');
        checkDBField($db,'cancel_reason', $table, 'text');

    } else {

        mysqli_query($db,"CREATE TABLE `m_cinestream_bookings` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `id_user` int(10) unsigned NOT NULL DEFAULT '0',
          `valid_from` datetime DEFAULT NULL,
          `valid_to` datetime DEFAULT NULL,
          `username` varchar(45) DEFAULT NULL,
          `password` varchar(45) DEFAULT NULL,
          `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          `customer_fullname` varchar(75) DEFAULT NULL,
          `phone` varchar(45) DEFAULT NULL,
          `cancelled` tinyint(1) NOT NULL DEFAULT '0',
          `cancel_reason` text,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_cinestream_general";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'param', $table, 'varchar(45) NOT NULL DEFAULT ""');
        checkDBField($db,'value', $table, 'longtext NOT NULL');

    } else {

        mysqli_query($db,"CREATE TABLE `m_cinestream_general` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `param` varchar(45) NOT NULL DEFAULT '',
          `value` longtext NOT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

        mysqli_query("INSERT INTO (param, value) VALUES ('customer_logo' , '')"); // Creo record vuoto

    }

    $table = "m_cinestream_menu";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'Description', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'Image', $table, 'longtext NOT NULL');
        checkDBField($db,'AutomationStart', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'AutomationEnd', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'Enabled', $table, 'tinyint(1) DEFAULT NULL');
        checkDBField($db,'Position', $table, 'int(10) unsigned DEFAULT 0');
        checkDBField($db,'AppID', $table, 'int(10) unsigned DEFAULT 0');
        checkDBField($db,'Argument', $table, 'varchar(255) DEFAULT NULL');
        checkDBField($db,'CommBgImage', $table, 'longtext');

    } else {

        mysqli_query($db, "CREATE TABLE `m_cinestream_menu` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `Description` varchar(45) DEFAULT NULL,
          `Image` longtext NOT NULL,
          `AutomationStart` varchar(45) DEFAULT NULL,
          `AutomationEnd` varchar(45) DEFAULT NULL,
          `Enabled` tinyint(1) DEFAULT NULL,
          `Position` int(10) unsigned DEFAULT '0',
          `AppID` int(10) unsigned DEFAULT '0',
          `Argument` varchar(255) DEFAULT NULL,
          `CommBgImage` longtext,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_cinestream_panel_users";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'username', $table, 'varchar(75) NOT NULL DEFAULT ""');
        checkDBField($db,'password', $table, 'varchar(75) NOT NULL DEFAULT ""');
        checkDBField($db,'level', $table, 'int(10) unsigned NOT NULL DEFAULT 0');

    } else {

        mysqli_query($db, "CREATE TABLE `m_cinestream_panel_users` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `username` varchar(75) NOT NULL DEFAULT '',
          `password` varchar(75) NOT NULL DEFAULT '',
          `level` int(10) unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

        // Admin admin default
        mysqli_query($db, "INSERT INTO m_cinestream_panel_users (username, password, level) VALUES ('admin' , 'admin' , 0)");

    }

    $table = "m_cinestream_users";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'username', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'password', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'api_address', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'api_port', $table, 'varchar(45) DEFAULT NULL');
        checkDBField($db,'expires', $table, 'datetime DEFAULT NULL');
        checkDBField($db,'id_theater', $table, 'int(10) unsigned DEFAULT NULL');
        checkDBField($db,'valid_from', $table, 'datetime DEFAULT NULL');

    } else {

        mysqli_query($db, "CREATE TABLE `m_cinestream_users` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `username` varchar(45) DEFAULT NULL,
          `password` varchar(45) DEFAULT NULL,
          `api_address` varchar(45) DEFAULT NULL,
          `api_port` varchar(45) DEFAULT NULL,
          `expires` datetime DEFAULT NULL,
          `id_theater` int(10) unsigned DEFAULT NULL,
          `valid_from` datetime DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    // check m_clips
  $table = "m_clips";
  if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

    checkDBField($db , "Channel" , $table , " varchar(7) DEFAULT '' ");
    checkDBField($db , "Groupname" , $table , " varchar(30) DEFAULT '' ");
    checkDBField($db , "Code" , $table , " varchar(25) DEFAULT '' ");
    checkDBField($db , "Title" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "Artist" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "Album" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "Track" , $table , " smallint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "Year" , $table , " smallint(4) unsigned DEFAULT '0' ");
    checkDBField($db , "Composer" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "Label" , $table , " varchar(50) DEFAULT '' ");

    checkDBField($db , "CopyR1" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR2" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR3" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR4" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR5" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR6" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR7" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR8" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR9" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "CopyR10" , $table , " varchar(100) DEFAULT '' ");

    checkDBField($db , "Source" , $table , " varchar(5) DEFAULT '' ");
    checkDBField($db , "Filename" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "Fileaudio" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "RadioFileaudio" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "Duration" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "VideoFPS" , $table , " decimal(10,0) DEFAULT '0' ");
    checkDBField($db , "VideoAspectRatio" , $table , " varchar(10) DEFAULT '' ");
    checkDBField($db , "VideoHeight" , $table , " smallint(5) unsigned DEFAULT '0' ");
    checkDBField($db , "MarkIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MarkOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Intro" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Outtro" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "CropT" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "CropB" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "CropL" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "CropR" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "FadeInOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "FadeOutOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Volume" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Hide" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "MixIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MixOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Energy" , $table , " smallint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "National" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "TextureIn" , $table , " tinyint(2) unsigned DEFAULT '0' ");
    checkDBField($db , "TextureOut" , $table , " tinyint(2) unsigned DEFAULT '0' ");
    checkDBField($db , "Image" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "SoundCode" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "Opener" , $table , " smallint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "Country" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "Layer" , $table , " smallint(5) unsigned DEFAULT '0' ");
    checkDBField($db , "BPM" , $table , " smallint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "Mood" , $table , " tinyint(1) unsigned DEFAULT '0' ");
    checkDBField($db , "Voice" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "Category" , $table , " varchar(30) DEFAULT '' ");

    checkDBField($db , "LastPlay" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "LastPlay1" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "LastPlay2" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "LastPlay3" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");

    checkDBField($db , "ValidHoursWeekly1" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly2" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly3" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly4" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly5" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly6" , $table , " int(11) DEFAULT '16777215' ");
    checkDBField($db , "ValidHoursWeekly7" , $table , " int(11) DEFAULT '16777215' ");

    checkDBField($db , "String1" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String2" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String3" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String4" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String5" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String6" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String7" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String8" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String9" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String10" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String11" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String12" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String13" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String14" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String15" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String16" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String17" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String18" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String19" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "String20" , $table , " varchar(100) DEFAULT '' ");

    checkDBField($db , "CreationDate" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "ModifyDate" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "ID_Parent" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "ForceField" , $table , " tinyint(2) unsigned DEFAULT '0' ");
    checkDBField($db , "KeepAspect" , $table , " tinyint(2) unsigned DEFAULT '1' ");
    checkDBField($db , "ID_Universal" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "TimeExtension" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "IgnoreMark" , $table , " smallint(2) unsigned DEFAULT '0' ");
    checkDBField($db , "MediaExist" , $table , " tinyint(1) DEFAULT '1' ");
    checkDBField($db , "ID_AutomationDefault" , $table , " bigint(20) DEFAULT '0' ");
    checkDBField($db , "ExecutionMode" , $table , " tinyint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "Props" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "Note" , $table , " text ");
    checkDBField($db , "AudioChannel" , $table , " varchar(30) DEFAULT '' ");
    checkDBField($db , "AudioProfile" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ValidityFrom" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "ValidityTo" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "ImportDate" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "ImportDate" , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
    checkDBField($db , "Content" , $table , " text ");
    checkDBField($db , "ShortMarkFadeInOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkFadeOutOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkMixIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkMixOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainFadeInOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainFadeOutOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainMixIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainMixOut" , $table , " int(11) DEFAULT '0' ");

  }else {

    mysqli_query($db,"CREATE TABLE  `m_clips` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `Channel` varchar(7) DEFAULT '',
  `Groupname` varchar(30) DEFAULT '',
  `Code` varchar(25) DEFAULT '',
  `Title` varchar(100) DEFAULT '',
  `Artist` varchar(100) DEFAULT '',
  `Album` varchar(100) DEFAULT '',
  `Track` smallint(3) unsigned DEFAULT '0',
  `Year` smallint(4) unsigned DEFAULT '0',
  `Composer` varchar(100) DEFAULT '',
  `Label` varchar(50) DEFAULT '',
  `CopyR1` varchar(100) DEFAULT '',
  `CopyR2` varchar(100) DEFAULT '',
  `CopyR3` varchar(100) DEFAULT '',
  `CopyR4` varchar(100) DEFAULT '',
  `CopyR5` varchar(100) DEFAULT '',
  `CopyR6` varchar(100) DEFAULT '',
  `CopyR7` varchar(100) DEFAULT '',
  `CopyR8` varchar(100) DEFAULT '',
  `CopyR9` varchar(100) DEFAULT '',
  `CopyR10` varchar(100) DEFAULT '',
  `Source` varchar(5) DEFAULT '',
  `Filename` varchar(254) DEFAULT '',
  `Fileaudio` varchar(254) DEFAULT '',
  `RadioFileaudio` varchar(254) DEFAULT '',
  `Duration` int(11) DEFAULT '0',
  `VideoFPS` decimal(10,0) DEFAULT '0',
  `VideoAspectRatio` varchar(10) DEFAULT '',
  `VideoWidth` smallint(5) unsigned DEFAULT '0',
  `VideoHeight` smallint(5) unsigned DEFAULT '0',
  `MarkIn` int(11) DEFAULT '0',
  `MarkOut` int(11) DEFAULT '0',
  `RefrainIn` int(11) DEFAULT '0',
  `RefrainOut` int(11) DEFAULT '0',
  `ShortMarkIn` int(11) DEFAULT '0',
  `ShortMarkOut` int(11) DEFAULT '0',
  `Intro` int(11) DEFAULT '0',
  `Outtro` int(11) DEFAULT '0',
  `CropT` int(11) DEFAULT '0',
  `CropB` int(11) DEFAULT '0',
  `CropL` int(11) DEFAULT '0',
  `CropR` int(11) DEFAULT '0',
  `FadeInOffset` int(11) DEFAULT '0',
  `FadeOutOffset` int(11) DEFAULT '0',
  `Volume` int(11) DEFAULT '0',
  `Hide` tinyint(1) DEFAULT '0',
  `MixIn` int(11) DEFAULT '0',
  `MixOut` int(11) DEFAULT '0',
  `Energy` smallint(3) unsigned DEFAULT '0',
  `National` tinyint(1) DEFAULT '0',
  `TextureIn` tinyint(2) unsigned DEFAULT '0',
  `TextureOut` tinyint(2) unsigned DEFAULT '0',
  `Image` varchar(254) DEFAULT '',
  `SoundCode` varchar(50) DEFAULT '',
  `Opener` smallint(3) unsigned DEFAULT '0',
  `Country` varchar(50) DEFAULT '',
  `Layer` smallint(5) unsigned DEFAULT '0',
  `BPM` smallint(3) unsigned DEFAULT '0',
  `Mood` tinyint(1) unsigned DEFAULT '0',
  `Voice` varchar(50) DEFAULT '',
  `Category` varchar(30) DEFAULT '',
  `LastPlay` datetime DEFAULT '0000-00-00 00:00:00',
  `LastPlay1` datetime DEFAULT '0000-00-00 00:00:00',
  `LastPlay2` datetime DEFAULT '0000-00-00 00:00:00',
  `LastPlay3` datetime DEFAULT '0000-00-00 00:00:00',
  `ValidMonths` smallint(6) DEFAULT '8190',
  `ValidHoursWeekly1` int(11) DEFAULT '16777215',
  `ValidHoursWeekly2` int(11) DEFAULT '16777215',
  `ValidHoursWeekly3` int(11) DEFAULT '16777215',
  `ValidHoursWeekly4` int(11) DEFAULT '16777215',
  `ValidHoursWeekly5` int(11) DEFAULT '16777215',
  `ValidHoursWeekly6` int(11) DEFAULT '16777215',
  `ValidHoursWeekly7` int(11) DEFAULT '16777215',
  `String1` varchar(100) DEFAULT '',
  `String2` varchar(100) DEFAULT '',
  `String3` varchar(100) DEFAULT '',
  `String4` varchar(100) DEFAULT '',
  `String5` varchar(100) DEFAULT '',
  `String6` varchar(100) DEFAULT '',
  `String7` varchar(100) DEFAULT '',
  `String8` varchar(100) DEFAULT '',
  `String9` varchar(100) DEFAULT '',
  `String10` varchar(100) DEFAULT '',
  `String11` varchar(100) DEFAULT '',
  `String12` varchar(100) DEFAULT '',
  `String13` varchar(100) DEFAULT '',
  `String14` varchar(100) DEFAULT '',
  `String15` varchar(100) DEFAULT '',
  `String16` varchar(100) DEFAULT '',
  `String17` varchar(100) DEFAULT '',
  `String18` varchar(100) DEFAULT '',
  `String19` varchar(100) DEFAULT '',
  `String20` varchar(100) DEFAULT '',
  `CreationDate` datetime DEFAULT '0000-00-00 00:00:00',
  `ModifyDate` datetime DEFAULT '0000-00-00 00:00:00',
  `ID_Parent` varchar(50) DEFAULT '',
  `ForceField` tinyint(2) unsigned DEFAULT '0',
  `KeepAspect` tinyint(2) unsigned DEFAULT '1',
  `ID_Universal` varchar(50) DEFAULT '',
  `TimeExtension` int(11) DEFAULT '0',
  `IgnoreMark` smallint(2) unsigned DEFAULT '0',
  `MediaExist` tinyint(1) DEFAULT '1',
  `ID_AutomationDefault` bigint(20) DEFAULT '0',
  `ExecutionMode` tinyint(3) unsigned DEFAULT '0',
  `Props` varchar(254) DEFAULT '',
  `Note` text,
  `AudioChannel` varchar(30) DEFAULT '',
  `AudioProfile` int(11) DEFAULT '0',
  `ValidityFrom` datetime DEFAULT '0000-00-00 00:00:00',
  `ValidityTo` datetime DEFAULT '0000-00-00 00:00:00',
  `ImportDate` datetime DEFAULT '0000-00-00 00:00:00',
  `Content` text,
  `ShortMarkFadeInOffset` int(11) DEFAULT '0',
  `ShortMarkFadeOutOffset` int(11) DEFAULT '0',
  `ShortMarkMixIn` int(11) DEFAULT '0',
  `ShortMarkMixOut` int(11) DEFAULT '0',
  `RefrainFadeInOffset` int(11) DEFAULT '0',
  `RefrainFadeOutOffset` int(11) DEFAULT '0',
  `RefrainMixIn` int(11) DEFAULT '0',
  `RefrainMixOut` int(11) DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `artist` (`Artist`) USING BTREE,
  KEY `chartist` (`Channel`,`Artist`) USING BTREE,
  KEY `chgroupname` (`Channel`,`Groupname`) USING BTREE,
  KEY `chcategory` (`Channel`,`Category`) USING BTREE,
  KEY `chcountry` (`Channel`,`Country`) USING BTREE,
  KEY `chsoundcode` (`Channel`,`SoundCode`) USING BTREE,
  KEY `chvoice` (`Channel`,`Voice`) USING BTREE,
  KEY `chtexturein` (`Channel`,`TextureIn`) USING BTREE,
  KEY `chtextureout` (`Channel`,`TextureOut`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;");

  }


    $table = "m_clips_images";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db,'id_universal', $table, 'varchar(60) NOT NULL DEFAULT ""');
        checkDBField($db,'Image64', $table, 'longtext');
        checkDBField($db,'DatastorePath', $table, 'text NOT NULL');

    } else {

        mysqli_query($db, "CREATE TABLE `m_clips_images` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `id_universal` varchar(60) NOT NULL DEFAULT '',
          `Image64` longtext,
          `DatastorePath` text NOT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1;");

    }

    // check m_clock_element
  $table = "m_clock_element";
  if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

    checkDBField($db , "Channel" , $table , " varchar(7) DEFAULT '' ");
    checkDBField($db , "Title" , $table , " varchar(100) DEFAULT '' ");
    checkDBField($db , "Category" , $table , " varchar(30) DEFAULT '' ");
    checkDBField($db , "Filename" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "Fileaudio" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "RadioFileaudio" , $table , " varchar(254) DEFAULT '' ");
    checkDBField($db , "Duration" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MarkIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MarkOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Note" , $table , " text ");
    checkDBField($db , "RunTime" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ID_Clock" , $table , " bigint(20) unsigned DEFAULT '0' ");
    checkDBField($db , "ID_Element" , $table , " bigint(20) unsigned DEFAULT '0' ");
    checkDBField($db , "Position" , $table , " bigint(20) unsigned NOT NULL DEFAULT '0' ");
    checkDBField($db , "Adjustable" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "Suspended" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "Chain" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "Table_Element" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "ID_EpisodeSchedule" , $table , " bigint(20) unsigned DEFAULT '0' ");
    checkDBField($db , "Segment" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "BlockDays" , $table , " smallint(4) DEFAULT '0' ");
    checkDBField($db , "BlockType" , $table , " tinyint(2) unsigned DEFAULT '0' ");
    checkDBField($db , "ModifiedByUser" , $table , " tinyint(1) DEFAULT '0' ");
    checkDBField($db , "RefrainIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "RefrainOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Intro" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Outtro" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "FadeInOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "FadeOutOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MixIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "MixOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Volume" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ExecutionMode" , $table , " tinyint(3) unsigned DEFAULT '0' ");
    checkDBField($db , "ShortMarkFadeInOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkFadeOutOffset" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkMixIn" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "ShortMarkMixOut" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "IntermissionStartAt" , $table , " bigint(20) unsigned NOT NULL DEFAULT '0' ");
    checkDBField($db , "IntermissionType" , $table , " int(10) unsigned NOT NULL DEFAULT '0' ");

  }else {

    mysqli_query($db,"CREATE TABLE  `m_clock_element` (
      `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
      `Channel` varchar(7) DEFAULT '',
      `Title` varchar(100) DEFAULT '',
      `Category` varchar(30) DEFAULT '',
      `Filename` varchar(254) DEFAULT '',
      `Fileaudio` varchar(254) DEFAULT '',
      `RadioFileaudio` varchar(254) DEFAULT '',
      `Duration` int(11) DEFAULT '0',
      `MarkIn` int(11) DEFAULT '0',
      `MarkOut` int(11) DEFAULT '0',
      `Note` text,
      `RunTime` int(11) DEFAULT '0',
      `ID_Clock` bigint(20) unsigned DEFAULT '0',
      `ID_Element` bigint(20) unsigned DEFAULT '0',
      `Position` bigint(20) unsigned NOT NULL DEFAULT '0',
      `Adjustable` tinyint(1) DEFAULT '0',
      `Suspended` tinyint(1) DEFAULT '0',
      `Chain` tinyint(1) DEFAULT '0',
      `Table_Element` varchar(50) DEFAULT '',
      `ID_EpisodeSchedule` bigint(20) unsigned DEFAULT '0',
      `Segment` int(11) DEFAULT '0',
      `BlockDays` smallint(4) DEFAULT '0',
      `BlockType` tinyint(2) unsigned DEFAULT '0',
      `ModifiedByUser` tinyint(1) DEFAULT '0',
      `RefrainIn` int(11) DEFAULT '0',
      `RefrainOut` int(11) DEFAULT '0',
      `ShortMarkIn` int(11) DEFAULT '0',
      `ShortMarkOut` int(11) DEFAULT '0',
      `Intro` int(11) DEFAULT '0',
      `Outtro` int(11) DEFAULT '0',
      `FadeInOffset` int(11) DEFAULT '0',
      `FadeOutOffset` int(11) DEFAULT '0',
      `MixIn` int(11) DEFAULT '0',
      `MixOut` int(11) DEFAULT '0',
      `Volume` int(11) DEFAULT '0',
      `ExecutionMode` tinyint(3) unsigned DEFAULT '0',
      `ShortMarkFadeInOffset` int(11) DEFAULT '0',
      `ShortMarkFadeOutOffset` int(11) DEFAULT '0',
      `ShortMarkMixIn` int(11) DEFAULT '0',
      `ShortMarkMixOut` int(11) DEFAULT '0',
      `RefrainFadeInOffset` int(11) DEFAULT '0',
      `RefrainFadeOutOffset` int(11) DEFAULT '0',
      `RefrainMixIn` int(11) DEFAULT '0',
      `RefrainMixOut` int(11) DEFAULT '0',
      `IntermissionStartAt` bigint(20) unsigned NOT NULL DEFAULT '0',
      `IntermissionType` int(10) unsigned NOT NULL DEFAULT '0',
      PRIMARY KEY (`ID`)
    ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

  }



  // check m_clock_list
  $table = "m_clock_list";
  if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

    checkDBField($db , "Channel" , $table , " varchar(7) DEFAULT '' ");
    checkDBField($db , "Duration" , $table , " int(11) DEFAULT '0' ");
    checkDBField($db , "Name" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "ReplaceName" , $table , " varchar(50) DEFAULT '' ");
    checkDBField($db , "IDAutomation" , $table , " bigint(20) DEFAULT '0' ");
    checkDBField($db , "Note" , $table , " text ");
    checkDBField($db , "RulesList" , $table , " text ");
    checkDBField($db , "CreationDate" , $table , " datetime DEFAULT NULL ");
    checkDBField($db , "ModifyDate" , $table , " datetime DEFAULT NULL ");
    checkDBField($db , "ImportDate" , $table , " datetime DEFAULT NULL ");
    checkDBField($db , "Color" , $table , " varchar(45) NOT NULL DEFAULT '#24682c' ");
    checkDBField($db , "uuid" , $table , " varchar(45) NOT NULL ");

  }else {

    mysqli_query($db,"CREATE TABLE  `m_clock_list` (
    `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `Channel` varchar(7) DEFAULT '',
    `Duration` int(11) DEFAULT '0',
    `Name` varchar(50) DEFAULT '',
    `ReplaceName` varchar(50) DEFAULT '',
    `IDAutomation` bigint(20) DEFAULT '0',
    `Note` text,
    `RulesList` text,
    `CreationDate` datetime DEFAULT NULL,
    `ModifyDate` datetime DEFAULT NULL,
    `ImportDate` datetime DEFAULT NULL,
    `Color` varchar(45) NOT NULL DEFAULT '#24682c',
    `uuid` varchar(45) NOT NULL,
    PRIMARY KEY (`ID`)
  ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

  }


    $table = "m_cpl_images";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "UuidCpl" , $table , "varchar(60) NOT NULL DEFAULT ''");
        checkDBField($db , "Image64" , $table , "longtext");
        checkDBField($db , "DatastorePath" , $table , "text NOT NULL");

    } else {

        mysqli_query($db,"CREATE TABLE `m_cpl_images` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `UuidCpl` varchar(60) NOT NULL DEFAULT '',
          `Image64` longtext,
          `DatastorePath` text NOT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_datastores";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "name" , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , "address" , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , "manager_address" , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , "username" , $table , "varchar(65) DEFAULT NULL");
        checkDBField($db , "password" , $table , "varchar(65) DEFAULT NULL");
        checkDBField($db , "filesystem_type" , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , "port" , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , "hula_store_docker" , $table , "varchar(75) DEFAULT NULL");

    } else {

        mysqli_query($db, "CREATE TABLE `m_datastores` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `name` varchar(45) DEFAULT NULL,
          `address` varchar(45) DEFAULT NULL,
          `manager_address` varchar(45) DEFAULT NULL,
          `username` varchar(65) DEFAULT NULL,
          `password` varchar(65) DEFAULT NULL,
          `filesystem_type` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `hula_store_docker` varchar(75) DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_device_settings";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "ID_DEVICE" , $table , "int(10) unsigned NOT NULL");
        checkDBField($db , "KEY1" , $table , "varchar(45) NOT NULL");
        checkDBField($db , "VALUESTRING" , $table , "varchar(45) DEFAULT NULL");

    } else {

        mysqli_query($db,"CREATE TABLE `m_device_settings` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `ID_DEVICE` int(10) unsigned NOT NULL,
          `KEY1` varchar(45) NOT NULL,
          `VALUESTRING` varchar(45) DEFAULT NULL,
          PRIMARY KEY (`ID`)         
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    $table = "m_device_tag_details";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "ID_TAG" , $table , "int(10) unsigned NOT NULL");
        checkDBField($db , "ID_DETAIL" , $table , "int(10) unsigned NOT NULL");
        checkDBField($db , "KEY1" , $table , "varchar(45) NOT NULL");
        checkDBField($db , "VALUESTRING" , $table , "varchar(512) DEFAULT NULL");

    } else {

        mysqli_query($db, "CREATE TABLE `m_device_tag_details` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `ID_TAG` int(10) unsigned NOT NULL,
          `ID_DETAIL` int(10) unsigned NOT NULL,
          `KEY1` varchar(45) NOT NULL,
          `VALUESTRING` varchar(512) DEFAULT NULL,
          PRIMARY KEY (`ID`)        
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;" );

    }

    $table = "m_device_tags";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "ID_UNIVERSAL" , $table , "varchar(45) NOT NULL");
        checkDBField($db , "DESCRIPTION" , $table , "varchar(45) NOT NULL");
        checkDBField($db , "ENABLED" , $table , "tinyint(1) NOT NULL");
        checkDBField($db , "ID_INSTANCE" , $table , "int(10) unsigned NOT NULL");

    } else {

        mysqli_query($db, "CREATE TABLE `m_device_tags` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `ID_UNIVERSAL` varchar(45) NOT NULL,
          `DESCRIPTION` varchar(45) NOT NULL,
          `ENABLED` tinyint(1) NOT NULL,
          `ID_INSTANCE` int(10) unsigned NOT NULL,
          PRIMARY KEY (`ID`)      
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_devices";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , "ID_INSTANCE" , $table , "int(10) unsigned NOT NULL");
        checkDBField($db , "DESCRIPTION" , $table , "varchar(45) NOT NULL");
        
    } else {

        mysqli_query($db,"CREATE TABLE `m_devices` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `ID_INSTANCE` int(10) unsigned NOT NULL,
          `DESCRIPTION` varchar(45) NOT NULL,
          PRIMARY KEY (`ID`)                
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    // check m_events
    $table = "m_events";
    if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

      checkDBField($db , 'ID_Element' , $table , " bigint(20) unsigned DEFAULT '0' ");
      checkDBField($db , 'Table_Element' , $table , " varchar(50) DEFAULT '' ");
      checkDBField($db , 'Item' , $table , " varchar(100) DEFAULT '' ");
      checkDBField($db , 'Param' , $table , " text ");
      checkDBField($db , 'TimeRef' , $table , " tinyint(1) unsigned DEFAULT '0' ");
      checkDBField($db , 'TimeStart' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'TimeEnd' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Duration' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'TimeEnter' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'TimeExit' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'TimeShow' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'EventType' , $table , " tinyint(1) unsigned DEFAULT '0' ");
      checkDBField($db , 'PosX' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'PosY' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'EventLoop' , $table , " tinyint(1) DEFAULT '0' ");
      checkDBField($db , 'Segment' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Destination' , $table , " tinyint(2) unsigned DEFAULT '0' ");
      checkDBField($db , 'Enable' , $table , " tinyint(1) DEFAULT '1' ");
      checkDBField($db , 'Hide' , $table , " tinyint(1) DEFAULT '0' ");

    } else {

      mysqli_query($db,"CREATE TABLE `m_events` (
        `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `ID_Element` bigint(20) unsigned DEFAULT '0',
        `Table_Element` varchar(50) DEFAULT '',
        `Item` varchar(100) DEFAULT '',
        `Param` text,
        `TimeRef` tinyint(1) unsigned DEFAULT '0',
        `TimeStart` int(11) DEFAULT '0',
        `TimeEnd` int(11) DEFAULT '0',
        `Duration` int(11) DEFAULT '0',
        `TimeEnter` int(11) DEFAULT '0',
        `TimeExit` int(11) DEFAULT '0',
        `TimeShow` int(11) DEFAULT '0',
        `EventType` tinyint(1) unsigned DEFAULT '0',
        `PosX` int(11) DEFAULT '0',
        `PosY` int(11) DEFAULT '0',
        `EventLoop` tinyint(1) DEFAULT '0',
        `Segment` int(11) DEFAULT '0',
        `Destination` tinyint(2) unsigned DEFAULT '0',
        `Enable` tinyint(1) DEFAULT '1',
        `Hide` tinyint(1) DEFAULT '0',
        PRIMARY KEY (`ID`)
      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_generalsettings";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'key1' , $table , " varchar(45) ");
        checkDBField($db , 'key2' , $table , " varchar(45) ");
        checkDBField($db , 'key3' , $table , " varchar(45) ");
        checkDBField($db , 'string_value' , $table , " varchar(150) DEFAULT NULL ");
        checkDBField($db , 'int_value' , $table , " int(10) unsigned DEFAULT NULL ");

    } else {

        mysqli_query($db,"CREATE TABLE `m_generalsettings` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `key1` varchar(45) NOT NULL DEFAULT '',
          `key2` varchar(45) NOT NULL DEFAULT '',
          `key3` varchar(45) DEFAULT NULL,
          `string_value` varchar(150) DEFAULT NULL,
          `int_value` int(10) unsigned DEFAULT NULL,
          PRIMARY KEY (`id`,`key1`,`key2`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_gpi";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'address' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'port' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'type' , $table , "int(10) unsigned NOT NULL DEFAULT 0");

    } else {

        mysqli_query($db,"CREATE TABLE `m_gpi` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `address` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `type` int(10) unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;");

    }

    $table = "m_imb";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'type' , $table , "varchar(45) NOT NULL DEFAULT ''");
        checkDBField($db , 'address' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'port' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'direct_streaming' , $table , "tinyint(1) NOT NULL DEFAULT 0");
        checkDBField($db , 'certified' , $table , "tinyint(1) NOT NULL DEFAULT 0");
        checkDBField($db , 'self_schedule' , $table , "tinyint(1) NOT NULL DEFAULT 0");
        checkDBField($db , 'id_datastore' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'api_username' , $table , "varchar(45) DEFAULT NULL COMMENT 'username di login per i portali degli imb'");
        checkDBField($db , 'api_password' , $table , "varchar(45) DEFAULT NULL COMMENT 'password, stessa cosa dell''username'");
        checkDBField($db , 'kdm_serial' , $table , "varchar(75) DEFAULT NULL");
        checkDBField($db , 'serial' , $table , "varchar(75) DEFAULT NULL");
        checkDBField($db , 'cineplayer_docker' , $table , " varchar(65) DEFAULT NULL");
        checkDBField($db , 'id_datastore_backup' , $table , " int(10) unsigned DEFAULT NULL COMMENT 'id datastore di backup'");


    } else {

        mysqli_query($db, "CREATE TABLE `m_imb` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `type` varchar(45) NOT NULL DEFAULT '',
          `address` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `direct_streaming` tinyint(1) NOT NULL DEFAULT '0',
          `certified` tinyint(1) NOT NULL DEFAULT '0',
          `self_schedule` tinyint(1) NOT NULL DEFAULT '0',
          `id_datastore` int(10) unsigned DEFAULT NULL,
          `api_username` varchar(45) DEFAULT NULL COMMENT 'username di login per i portali degli imb',
          `api_password` varchar(45) DEFAULT NULL COMMENT 'password, stessa cosa dell''username',
          `kdm_serial` varchar(75) DEFAULT NULL,
          `serial` varchar(75) DEFAULT NULL,
          `cineplayer_docker` varchar(65) DEFAULT NULL,
          `id_datastore_backup` int(10) unsigned DEFAULT NULL COMMENT 'id datastore di backup',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_import_kdm_preset";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'name' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'path' , $table , "varchar(155) DEFAULT NULL");
        checkDBField($db , 'enabled' , $table , "tinyint(3) unsigned NOT NULL DEFAULT 1");

    } else {

        mysqli_query($db, "CREATE TABLE `m_import_kdm_preset` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `name` varchar(45) DEFAULT NULL,
          `path` varchar(155) DEFAULT NULL,
          `enabled` tinyint(3) unsigned NOT NULL DEFAULT '1',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='tabella dei preset import di ingest kdm';");

        mysqli_query($db,"INSERT INTO m_import_kdm_preset (name, path, enabled) VALUES ('Default KDM' , '/datastore/kdm_preset_folder' , 1)");

    }


    $table = "m_import_preset";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'name' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'path' , $table , " varchar(155) DEFAULT NULL");
        checkDBField($db , 'enabled' , $table , "tinyint(3) unsigned NOT NULL DEFAULT 1");

    } else {

        mysqli_query($db,"CREATE TABLE `m_import_preset` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `name` varchar(45) DEFAULT NULL,
          `path` varchar(155) DEFAULT NULL,
          `enabled` tinyint(3) unsigned NOT NULL DEFAULT '1',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='tabella dei preset import di copia dcp';");

        mysqli_query($db,"INSERT INTO m_import_preset (name, path, enabled) VALUES ('FILM' , '/datastore/MEDIA/FILM' , 1)");
        mysqli_query($db,"INSERT INTO m_import_preset (name, path, enabled) VALUES ('TRAILER' , '/datastore/MEDIA/TRAILER' , 1)");
        mysqli_query($db,"INSERT INTO m_import_preset (name, path, enabled) VALUES ('ADV' , '/datastore/MEDIA/ADV' , 1)");
        mysqli_query($db,"INSERT INTO m_import_preset (name, path, enabled) VALUES ('VARIOUS' , '/datastore/MEDIA/VARIOUS' , 1)");
        //mysqli_query($db,"INSERT INTO m_import_preset (name, path, enabled) VALUES ('VARIOUS' , '/datastore/MEDIA/VARIOUS' , 1)");

    }

    $table = "m_ingestsources";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'name' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'type' , $table , "tinyint(3) unsigned DEFAULT NULL");
        checkDBField($db , 'address' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'port' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'username' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'password' , $table , "varchar(75) DEFAULT NULL");
        checkDBField($db , 'path' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'enabled' , $table , "tinyint(3) unsigned NOT NULL DEFAULT 1");

    } else {

        mysqli_query($db,"CREATE TABLE `m_ingestsources` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `name` varchar(45) DEFAULT NULL,
          `type` tinyint(3) unsigned DEFAULT NULL,
          `address` varchar(45) DEFAULT NULL,
          `port` int(10) unsigned DEFAULT NULL,
          `username` varchar(45) DEFAULT NULL,
          `password` varchar(75) DEFAULT NULL,
          `path` varchar(45) DEFAULT NULL,
          `enabled` tinyint(3) unsigned NOT NULL DEFAULT '1',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;");

        // Creo link locale di MEDIA
        mysqli_query($db, "INSERT INTO m_ingestsources (name, type, address, port, username, password, path, enabled) VALUES ('NAME', 0 , '' , 0 , '' , '' , '/datastore/MEDIA' , 1)");

    }

    $table = "m_instance_settings";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'ID_INSTANCE' , $table , "int(10) unsigned NOT NULL");
        checkDBField($db , 'KEY1' , $table , "varchar(45) NOT NULL");
        checkDBField($db , 'VALUESTRING' , $table , "varchar(45) DEFAULT NULL");

    } else {

        mysqli_query($db, "CREATE TABLE `m_instance_settings` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `ID_INSTANCE` int(10) unsigned NOT NULL,
          `KEY1` varchar(45) NOT NULL,
          `VALUESTRING` varchar(45) DEFAULT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_instances";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'NAME' , $table , "varchar(45) NOT NULL");
        checkDBField($db , 'DESCRIPTION' , $table , "varchar(45) NOT NULL");
        checkDBField($db , 'COMPUTER' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'ID_THEATER' , $table , "int(10) unsigned DEFAULT NULL");

    } else {

        mysqli_query($db, "CREATE TABLE `m_instances` (
          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `NAME` varchar(45) NOT NULL,
          `DESCRIPTION` varchar(45) NOT NULL,
          `COMPUTER` varchar(45) DEFAULT NULL,
          `ID_THEATER` int(10) unsigned DEFAULT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

        // Creo istanza generica
        mysqli_query($db,"INSERT INTO m_instances (NAME, DESCRIPTION, COMPUTER) VALUES ('G00' , 'G00' , 'STREAMER')");

    }

    // check m_manual_playlist
    $table = "m_manual_playlist";
    if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

      checkDBField($db , 'Channel' , $table , " varchar(7) DEFAULT '' ");
      checkDBField($db , 'Description' , $table , " varchar(250) DEFAULT '' ");
      checkDBField($db , 'Duration' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'CreationDate' , $table , " datetime DEFAULT NULL ");
      checkDBField($db , 'ModifyDate' , $table , " datetime DEFAULT NULL ");
      checkDBField($db , 'ImportDate' , $table , " datetime DEFAULT NULL ");

    } else {

      mysqli_query($db,"CREATE TABLE `m_manual_playlist` (
        `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `Channel` varchar(7) DEFAULT '',
        `Description` varchar(250) DEFAULT '',
        `Duration` int(11) DEFAULT '0',
        `CreationDate` datetime DEFAULT NULL,
        `ModifyDate` datetime DEFAULT NULL,
        `ImportDate` datetime DEFAULT NULL,
        PRIMARY KEY (`ID`)
      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    // check m_manual_playlist_detail
    $table = "m_manual_playlist_detail";
    if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){

      checkDBField($db , 'Title' , $table , " varchar(100) DEFAULT '' ");
      checkDBField($db , 'ID_Parent' , $table , " bigint(20) unsigned DEFAULT '0' ");
      checkDBField($db , 'Table_Element' , $table , " varchar(50) DEFAULT '' ");
      checkDBField($db , 'ID_Element' , $table , " bigint(20) unsigned DEFAULT '0' ");
      checkDBField($db , 'Position' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Duration' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Adjustable' , $table , " tinyint(1) DEFAULT '0' ");
      checkDBField($db , 'Chain' , $table , " tinyint(1) DEFAULT '0' ");
      checkDBField($db , 'ModifiedByUser' , $table , " tinyint(1) DEFAULT '0' ");
      checkDBField($db , 'MarkIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'MarkOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Intro' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Outtro' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'FadeInOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'FadeOutOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'MixIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'MixOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Volume' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'Note' , $table , " text ");
      checkDBField($db , 'Category' , $table , " varchar(30) DEFAULT '' ");
      checkDBField($db , 'ExecutionMode' , $table , " tinyint(3) unsigned DEFAULT '0' ");
      checkDBField($db , 'IntermissionType' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'IntermissionStartAt' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkFadeInOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkFadeOutOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkMixIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'ShortMarkMixOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainFadeInOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainFadeOutOffset' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainMixIn' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RefrainMixOut' , $table , " int(11) DEFAULT '0' ");
      checkDBField($db , 'RunTime' , $table , " bigint(20) unsigned DEFAULT '0' ");

    } else {

      mysqli_query($db,"CREATE TABLE `m_manual_playlist_detail` (
        `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `Title` varchar(100) DEFAULT '',
        `ID_Parent` bigint(20) unsigned DEFAULT '0',
        `Table_Element` varchar(50) DEFAULT '',
        `ID_Element` bigint(20) unsigned DEFAULT '0',
        `Position` int(11) DEFAULT '0',
        `Duration` int(11) DEFAULT '0',
        `Adjustable` tinyint(1) DEFAULT '0',
        `Chain` tinyint(1) DEFAULT '0',
        `ModifiedByUser` tinyint(1) DEFAULT '0',
        `MarkIn` int(11) DEFAULT '0',
        `MarkOut` int(11) DEFAULT '0',
        `RefrainIn` int(11) DEFAULT '0',
        `RefrainOut` int(11) DEFAULT '0',
        `ShortMarkIn` int(11) DEFAULT '0',
        `ShortMarkOut` int(11) DEFAULT '0',
        `Intro` int(11) DEFAULT '0',
        `Outtro` int(11) DEFAULT '0',
        `FadeInOffset` int(11) DEFAULT '0',
        `FadeOutOffset` int(11) DEFAULT '0',
        `MixIn` int(11) DEFAULT '0',
        `MixOut` int(11) DEFAULT '0',
        `Volume` int(11) DEFAULT '0',
        `Note` text,
        `Category` varchar(30) DEFAULT '',
        `ExecutionMode` tinyint(3) unsigned DEFAULT '0',
        `IntermissionType` int(11) DEFAULT '0',
        `IntermissionStartAt` int(11) DEFAULT '0',
        `ShortMarkFadeInOffset` int(11) DEFAULT '0',
        `ShortMarkFadeOutOffset` int(11) DEFAULT '0',
        `ShortMarkMixIn` int(11) DEFAULT '0',
        `ShortMarkMixOut` int(11) DEFAULT '0',
        `RefrainFadeInOffset` int(11) DEFAULT '0',
        `RefrainFadeOutOffset` int(11) DEFAULT '0',
        `RefrainMixIn` int(11) DEFAULT '0',
        `RefrainMixOut` int(11) DEFAULT '0',
        `RunTime` bigint(20) unsigned DEFAULT '0',
        PRIMARY KEY (`ID`)
      ) ENGINE=InnoDB AUTO_INCREMENT=1  DEFAULT CHARSET=utf8;");

    }

    $table = "m_projector";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'address' , $table , " varchar(45) DEFAULT NULL ");
        checkDBField($db , 'port' , $table , " varchar(45) DEFAULT NULL ");
        checkDBField($db , 'type' , $table , " int(10) unsigned NOT NULL DEFAULT 0 ");

    } else {

        mysqli_query($db,"CREATE TABLE `m_projector` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `address` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `type` int(10) unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_projector_macros";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'id_theater' , $table , " int(10) unsigned DEFAULT NULL ");
        checkDBField($db , 'macro' , $table , " varchar(75) DEFAULT NULL ");
        checkDBField($db , 'macro_index' , $table , " int(10) unsigned DEFAULT NULL ");

    } else {

        mysqli_query($db, "CREATE TABLE `m_projector_macros` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `id_theater` int(10) unsigned DEFAULT NULL,
          `macro` varchar(75) DEFAULT NULL,
          `macro_index` int(10) unsigned DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    


    $table = "m_streamer_users";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'username' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'password' , $table , "varchar(75) DEFAULT NULL");
        checkDBField($db , 'user_level' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'timestamp' , $table , "timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        checkDBField($db , 'active' , $table , "tinyint(3) unsigned NOT NULL DEFAULT 1");

    } else {

        mysqli_query($db, "CREATE TABLE `m_streamer_users` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `username` varchar(45) DEFAULT NULL,
          `password` varchar(45) DEFAULT NULL,
          `user_level` int(10) unsigned DEFAULT NULL,
          `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;");

    }

    $table = "m_streamercop_verify";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'uuid' , $table , " varchar(45) NOT NULL DEFAULT ''");
        checkDBField($db , 'id_cpl' , $table , " int(10) unsigned NOT NULL DEFAULT 0");
        checkDBField($db , 'progress' , $table , " varchar(45) NOT NULL DEFAULT ''");
        checkDBField($db , 'verify_status' , $table , " longtext NOT NULL");
        checkDBField($db , 'folder' , $table , " text NOT NULL");
        checkDBField($db , 'filename' , $table , " varchar(255) NOT NULL DEFAULT ''");
        checkDBField($db , 'error' , $table , " int(10) unsigned NOT NULL DEFAULT '0'");
        checkDBField($db , 'datefrom' , $table , " datetime NOT NULL DEFAULT '0000-00-00 00:00:00'");
        checkDBField($db , 'datastore_name' , $table , " varchar(45) NOT NULL DEFAULT ''");
        checkDBField($db , 'queued' , $table , "int(10) unsigned NOT NULL DEFAULT '0'");
        checkDBField($db , 'modifydate' , $table , "datetime DEFAULT NULL");
        checkDBField($db , 'title' , $table , "varchar(75) DEFAULT NULL");

    } else {

        mysqli_query($db,"CREATE TABLE `m_streamercop_verify` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `uuid` varchar(45) NOT NULL DEFAULT '',
          `id_cpl` int(10) unsigned NOT NULL DEFAULT '0',
          `progress` varchar(45) NOT NULL DEFAULT '',
          `verify_status` longtext NOT NULL,
          `folder` text NOT NULL,
          `filename` varchar(255) NOT NULL DEFAULT '',
          `error` int(10) unsigned NOT NULL DEFAULT '0',
          `datefrom` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
          `datastore_name` varchar(45) NOT NULL DEFAULT '',
          `queued` int(10) unsigned NOT NULL DEFAULT '0',
          `modifydate` datetime DEFAULT NULL,
          `title` varchar(75) DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");

    }

    $table = "m_switch";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'address' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'port' , $table , "varchar(45) DEFAULT NULL");
        checkDBField($db , 'type' , $table , "int(10) unsigned NOT NULL DEFAULT '0'");

    } else {

        mysqli_query($db, "CREATE TABLE `m_switch` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `address` varchar(45) DEFAULT NULL,
          `port` varchar(45) DEFAULT NULL,
          `type` int(10) unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }


    $table = "m_template_week";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'Channel' , $table , " varchar(7) DEFAULT ''");
        checkDBField($db , 'ID_Template' , $table , "bigint(20) unsigned DEFAULT '0'");
        checkDBField($db , 'ID_Clock' , $table , "bigint(20) unsigned DEFAULT '0'");
        checkDBField($db , 'DayOfWeek' , $table , "tinyint(1) unsigned DEFAULT '0'");
        checkDBField($db , 'BeginHour' , $table , "int(11) DEFAULT '0'");

    } else {

        mysqli_query($db,"CREATE TABLE `m_template_week` (
          `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
          `Channel` varchar(7) DEFAULT '',
          `ID_Template` bigint(20) unsigned DEFAULT '0',
          `ID_Clock` bigint(20) unsigned DEFAULT '0',
          `DayOfWeek` tinyint(1) unsigned DEFAULT '0',
          `BeginHour` int(11) DEFAULT '0',
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

    $table = "m_theaters";
    if(mysqli_query($db,"SELECT 1 FROM `{$table}` LIMIT 1")){

        checkDBField($db , 'name' , $table , "varchar(45) NOT NULL DEFAULT ''");
        checkDBField($db , 'theater_nr' , $table , "int(10) unsigned NOT NULL DEFAULT '0'");
        checkDBField($db , 'id_imb' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'id_projector' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'id_audioprocessor' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'id_gpi' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'id_switch' , $table , "int(10) unsigned DEFAULT NULL");
        checkDBField($db , 'description' , $table , "varchar(75) NOT NULL DEFAULT ''");
        checkDBField($db , 'note' , $table , "text");

    } else {

        mysqli_query($db, "CREATE TABLE `m_theaters` (
          `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
          `name` varchar(45) NOT NULL DEFAULT '',
          `theater_nr` int(10) unsigned NOT NULL DEFAULT '0',
          `id_imb` int(10) unsigned DEFAULT NULL,
          `id_projector` int(10) unsigned DEFAULT NULL,
          `id_audioprocessor` int(10) unsigned DEFAULT NULL,
          `id_gpi` int(10) unsigned DEFAULT NULL,
          `id_switch` int(10) unsigned DEFAULT NULL,
          `description` varchar(75) NOT NULL DEFAULT '',
          `note` text,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");

    }

      // check m_dcp
      $table = "m_dcp";
      if($check = mysqli_query($db,"SELECT * FROM ".$table." LIMIT 1")){
  
          checkDBField($db , 'Channel' , $table , " varchar(7) DEFAULT '' ");
          checkDBField($db , 'Groupname' , $table , " varchar(30) DEFAULT '' ");
          checkDBField($db , 'Code' , $table , " varchar(25) DEFAULT '' ");
          checkDBField($db , 'Title' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'Artist' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'Album' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'Track' , $table , " smallint(3) unsigned DEFAULT '0' ");
          checkDBField($db , 'Year' , $table , " smallint(4) unsigned DEFAULT '0' ");
          checkDBField($db , 'Composer' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'Label' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'CopyR1' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR2' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR3' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR4' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR5' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR6' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR7' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR8' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR9' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CopyR10' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'Source' , $table , " varchar(5) DEFAULT '' ");
          checkDBField($db , 'Filename' , $table , " varchar(254) DEFAULT '' ");
          checkDBField($db , 'Fileaudio' , $table , " varchar(254) DEFAULT '' ");
          checkDBField($db , 'RadioFileaudio' , $table , " varchar(254) DEFAULT '' ");
          checkDBField($db , 'Duration' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'VideoFPS' , $table , " decimal(10,0) DEFAULT '0' ");
          checkDBField($db , 'VideoAspectRatio' , $table , " varchar(10) DEFAULT '' ");
          checkDBField($db , 'VideoWidth' , $table , " smallint(5) unsigned DEFAULT '0' ");
          checkDBField($db , 'VideoHeight' , $table , " smallint(5) unsigned DEFAULT '0' ");
          checkDBField($db , 'MarkIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'MarkOut' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainOut' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ShortMarkIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ShortMarkOut' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'Intro' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'Outtro' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'CropT' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'CropB' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'CropL' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'CropR' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'FadeInOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'FadeOutOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'Volume' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'Hide' , $table , " tinyint(1) DEFAULT '0' ");
          checkDBField($db , 'MixIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'MixOut' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'Energy' , $table , " smallint(3) unsigned DEFAULT '0' ");
          checkDBField($db , 'National' , $table , " tinyint(1) DEFAULT '0' ");
          checkDBField($db , 'TextureIn' , $table , " tinyint(2) unsigned DEFAULT '0' ");
          checkDBField($db , 'TextureOut' , $table , " tinyint(2) unsigned DEFAULT '0' ");
          checkDBField($db , 'Image' , $table , " varchar(254) DEFAULT '' ");
          checkDBField($db , 'SoundCode' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'Opener' , $table , " smallint(3) unsigned DEFAULT '0' ");
          checkDBField($db , 'Country' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'Layer' , $table , " smallint(5) unsigned DEFAULT '0' ");
          checkDBField($db , 'BPM' , $table , " smallint(3) unsigned DEFAULT '0' ");
          checkDBField($db , 'Mood' , $table , " tinyint(1) unsigned DEFAULT '0' ");
          checkDBField($db , 'Voice' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'Category' , $table , " varchar(30) DEFAULT '' ");
          checkDBField($db , 'LastPlay' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'LastPlay1' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'LastPlay2' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'LastPlay3' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'ValidMonths' , $table , " smallint(6) DEFAULT '8190' ");
          checkDBField($db , 'ValidHoursWeekly1' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly2' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly3' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly4' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly5' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly6' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'ValidHoursWeekly7' , $table , " int(11) DEFAULT '16777215' ");
          checkDBField($db , 'String1' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String2' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String3' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String4' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String5' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String6' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String7' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String8' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String9' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String10' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String11' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String12' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String13' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String14' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String15' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String16' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String17' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String18' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String19' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'String20' , $table , " varchar(100) DEFAULT '' ");
          checkDBField($db , 'CreationDate' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'ModifyDate' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'ID_Parent' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'ForceField' , $table , " tinyint(2) unsigned DEFAULT '0' ");
          checkDBField($db , 'KeepAspect' , $table , " tinyint(2) unsigned DEFAULT '1' ");
          checkDBField($db , 'ID_Universal' , $table , " varchar(50) DEFAULT '' ");
          checkDBField($db , 'TimeExtension' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'IgnoreMark' , $table , " smallint(2) unsigned DEFAULT '0' ");
          checkDBField($db , 'MediaExist' , $table , " tinyint(1) DEFAULT '1' ");
          checkDBField($db , 'ID_AutomationDefault' , $table , " bigint(20) DEFAULT '0' ");
          checkDBField($db , 'ExecutionMode' , $table , " tinyint(3) unsigned DEFAULT '0' ");
          checkDBField($db , 'Props' , $table , " varchar(254) DEFAULT '' ");
          checkDBField($db , 'Note' , $table , " text ");
          checkDBField($db , 'AudioChannel' , $table , " varchar(30) DEFAULT '' ");
          checkDBField($db , 'AudioProfile' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ValidityFrom' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'ValidityTo' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'ImportDate' , $table , " datetime DEFAULT '0000-00-00 00:00:00' ");
          checkDBField($db , 'Content' , $table , " text ");
          checkDBField($db , 'ShortMarkFadeInOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ShortMarkFadeOutOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ShortMarkMixIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'ShortMarkMixOut' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainFadeInOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainFadeOutOffset' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainMixIn' , $table , " int(11) DEFAULT '0' ");
          checkDBField($db , 'RefrainMixOut' , $table , " int(11) DEFAULT '0' ");
  
      } else {
  
        mysqli_query($db,"CREATE TABLE `m_dcp` (
          `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
          `Channel` varchar(7) DEFAULT '',
          `Groupname` varchar(30) DEFAULT '',
          `Code` varchar(25) DEFAULT '',
          `Title` varchar(100) DEFAULT '',
          `Artist` varchar(100) DEFAULT '',
          `Album` varchar(100) DEFAULT '',
          `Track` smallint(3) unsigned DEFAULT '0',
          `Year` smallint(4) unsigned DEFAULT '0',
          `Composer` varchar(100) DEFAULT '',
          `Label` varchar(50) DEFAULT '',
          `CopyR1` varchar(100) DEFAULT '',
          `CopyR2` varchar(100) DEFAULT '',
          `CopyR3` varchar(100) DEFAULT '',
          `CopyR4` varchar(100) DEFAULT '',
          `CopyR5` varchar(100) DEFAULT '',
          `CopyR6` varchar(100) DEFAULT '',
          `CopyR7` varchar(100) DEFAULT '',
          `CopyR8` varchar(100) DEFAULT '',
          `CopyR9` varchar(100) DEFAULT '',
          `CopyR10` varchar(100) DEFAULT '',
          `Source` varchar(5) DEFAULT '',
          `Filename` varchar(254) DEFAULT '',
          `Fileaudio` varchar(254) DEFAULT '',
          `RadioFileaudio` varchar(254) DEFAULT '',
          `Duration` int(11) DEFAULT '0',
          `VideoFPS` decimal(10,0) DEFAULT '0',
          `VideoAspectRatio` varchar(10) DEFAULT '',
          `VideoWidth` smallint(5) unsigned DEFAULT '0',
          `VideoHeight` smallint(5) unsigned DEFAULT '0',
          `MarkIn` int(11) DEFAULT '0',
          `MarkOut` int(11) DEFAULT '0',
          `RefrainIn` int(11) DEFAULT '0',
          `RefrainOut` int(11) DEFAULT '0',
          `ShortMarkIn` int(11) DEFAULT '0',
          `ShortMarkOut` int(11) DEFAULT '0',
          `Intro` int(11) DEFAULT '0',
          `Outtro` int(11) DEFAULT '0',
          `CropT` int(11) DEFAULT '0',
          `CropB` int(11) DEFAULT '0',
          `CropL` int(11) DEFAULT '0',
          `CropR` int(11) DEFAULT '0',
          `FadeInOffset` int(11) DEFAULT '0',
          `FadeOutOffset` int(11) DEFAULT '0',
          `Volume` int(11) DEFAULT '0',
          `Hide` tinyint(1) DEFAULT '0',
          `MixIn` int(11) DEFAULT '0',
          `MixOut` int(11) DEFAULT '0',
          `Energy` smallint(3) unsigned DEFAULT '0',
          `National` tinyint(1) DEFAULT '0',
          `TextureIn` tinyint(2) unsigned DEFAULT '0',
          `TextureOut` tinyint(2) unsigned DEFAULT '0',
          `Image` varchar(254) DEFAULT '',
          `SoundCode` varchar(50) DEFAULT '',
          `Opener` smallint(3) unsigned DEFAULT '0',
          `Country` varchar(50) DEFAULT '',
          `Layer` smallint(5) unsigned DEFAULT '0',
          `BPM` smallint(3) unsigned DEFAULT '0',
          `Mood` tinyint(1) unsigned DEFAULT '0',
          `Voice` varchar(50) DEFAULT '',
          `Category` varchar(30) DEFAULT '',
          `LastPlay` datetime DEFAULT '1000-01-01 00:00:00',
          `LastPlay1` datetime DEFAULT '1000-01-01 00:00:00',
          `LastPlay2` datetime DEFAULT '1000-01-01 00:00:00',
          `LastPlay3` datetime DEFAULT '1000-01-01 00:00:00',
          `ValidMonths` smallint(6) DEFAULT '8190',
          `ValidHoursWeekly1` int(11) DEFAULT '16777215',
          `ValidHoursWeekly2` int(11) DEFAULT '16777215',
          `ValidHoursWeekly3` int(11) DEFAULT '16777215',
          `ValidHoursWeekly4` int(11) DEFAULT '16777215',
          `ValidHoursWeekly5` int(11) DEFAULT '16777215',
          `ValidHoursWeekly6` int(11) DEFAULT '16777215',
          `ValidHoursWeekly7` int(11) DEFAULT '16777215',
          `String1` varchar(100) DEFAULT '',
          `String2` varchar(100) DEFAULT '',
          `String3` varchar(100) DEFAULT '',
          `String4` varchar(100) DEFAULT '',
          `String5` varchar(100) DEFAULT '',
          `String6` varchar(100) DEFAULT '',
          `String7` varchar(100) DEFAULT '',
          `String8` varchar(100) DEFAULT '',
          `String9` varchar(100) DEFAULT '',
          `String10` varchar(100) DEFAULT '',
          `String11` varchar(100) DEFAULT '',
          `String12` varchar(100) DEFAULT '',
          `String13` varchar(100) DEFAULT '',
          `String14` varchar(100) DEFAULT '',
          `String15` varchar(100) DEFAULT '',
          `String16` varchar(100) DEFAULT '',
          `String17` varchar(100) DEFAULT '',
          `String18` varchar(100) DEFAULT '',
          `String19` varchar(100) DEFAULT '',
          `String20` varchar(100) DEFAULT '',
          `CreationDate` datetime DEFAULT '1000-01-01 00:00:00',
          `ModifyDate` datetime DEFAULT '1000-01-01 00:00:00',
          `ID_Parent` varchar(50) DEFAULT '',
          `ForceField` tinyint(2) unsigned DEFAULT '0',
          `KeepAspect` tinyint(2) unsigned DEFAULT '1',
          `ID_Universal` varchar(50) DEFAULT '',
          `TimeExtension` int(11) DEFAULT '0',
          `IgnoreMark` smallint(2) unsigned DEFAULT '0',
          `MediaExist` tinyint(1) DEFAULT '1',
          `ID_AutomationDefault` bigint(20) DEFAULT '0',
          `ExecutionMode` tinyint(3) unsigned DEFAULT '0',
          `Props` varchar(254) DEFAULT '',
          `Note` text,
          `AudioChannel` varchar(30) DEFAULT '',
          `AudioProfile` int(11) DEFAULT '0',
          `ValidityFrom` datetime DEFAULT '1000-01-01 00:00:00',
          `ValidityTo` datetime DEFAULT '1000-01-01 00:00:00',
          `ImportDate` datetime DEFAULT '1000-01-01 00:00:00',
          `Content` text,
          `ShortMarkFadeInOffset` int(11) DEFAULT '0',
          `ShortMarkFadeOutOffset` int(11) DEFAULT '0',
          `ShortMarkMixIn` int(11) DEFAULT '0',
          `ShortMarkMixOut` int(11) DEFAULT '0',
          `RefrainFadeInOffset` int(11) DEFAULT '0',
          `RefrainFadeOutOffset` int(11) DEFAULT '0',
          `RefrainMixIn` int(11) DEFAULT '0',
          `RefrainMixOut` int(11) DEFAULT '0',
          PRIMARY KEY (`ID`),
          KEY `artist` (`Artist`) USING BTREE,
          KEY `chartist` (`Channel`,`Artist`) USING BTREE,
          KEY `chgroupname` (`Channel`,`Groupname`) USING BTREE,
          KEY `chcategory` (`Channel`,`Category`) USING BTREE,
          KEY `chcountry` (`Channel`,`Country`) USING BTREE,
          KEY `chsoundcode` (`Channel`,`SoundCode`) USING BTREE,
          KEY `chvoice` (`Channel`,`Voice`) USING BTREE,
          KEY `chtexturein` (`Channel`,`TextureIn`) USING BTREE,
          KEY `chtextureout` (`Channel`,`TextureOut`) USING BTREE
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;");
  
      }


    //return true;
    

    // FUNZIONE CHECK
    function checkDBField($db, $field, $table,  $field_format){

        //global $db;

        if( mysqli_query($db, "SELECT `".$field."` FROM `".$table."` LIMIT 1") )
            return mysqli_query($db, "ALTER TABLE `".$table."` CHANGE COLUMN `".$field."` `".$field."` " . $field_format);                
        else 
            return mysqli_query($db, "ALTER TABLE `".$table."` ADD COLUMN `".$field."` " . $field_format);

    }



?>