#!/usr/bin/env bash
# If you are executing this script in cron with a restricted environment,
# modify the shebang to specify appropriate path; /bin/bash in most distros.
# And, also if you aren't comfortable using(abuse?) env command.

# This script is based on https://serverfault.com/a/767079 posted
# by Mike Blackwell, modified to our needs. Credits to the author.

# This script is called from systemd unit file to mount or unmount
# a USB drive.
source /usr/local/bin/bash-logger.sh
export LOGFILE=/var/log/usb-mount.log

ERROR()     { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
CRITICAL()  { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
ALERT()     { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }
EMERGENCY() { LOG_HANDLER_DEFAULT "$FUNCNAME" "$@"; }


PATH="$PATH:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin:/bin:/sbin"

ACTION=$1
DEVBASE=$2
DEVICE="/dev/${DEVBASE}"

LOG_HANDLER_DEFAULT() {
    local formatted_log="$(FORMAT_LOG "$@")"
    LOG_HANDLER_COLORTERM "$1" "$formatted_log"
    LOG_HANDLER_LOGFILE "$1" "$formatted_log"
    echo "logged to logfile"
}

do_mount()
{
	sleep 3
	eval $(blkid -o udev ${DEVICE} | grep -i -e "ID_FS_TYPE")
	FSTYPE=${ID_FS_TYPE}
	if [ -z ${FSTYPE} ]; then
		INFO "<${ACTION} - ${DEVICE}>"
		ERROR "${DEVICE} HAS NOT A MOUNTABLE FILESYSTEM IS A UNIT"
	else
		INFO "<${ACTION} - ${DEVICE}>"
		eval $(blkid -ipo full ${DEVICE})
		INFO "DEVICE NAME=${DEVNAME}"
		INFO "UUID=${UUID}"
		INFO "VERSION=${VERSION}"
		INFO "FILESYSTEM TYPE=${TYPE}"
		INFO "USAGE=${USAGE}"
		INFO "IO SIZE=${MINIMUM_IO_SIZE}"
		INFO "FISICAL SECTOR SIZE=${PHYSICAL_SECTOR_SIZE}"
		INFO "LOGICAL SECTOR SIZE=${LOGICAL_SECTOR_SIZE}"

	    INFO "START MOUNTING ${DEVICE} WITH FILESYSTEM ${FSTYPE}"
		if ! udisksctl mount -b ${DEVICE} ; then
			ERROR "ERROR MOUNTING ${DEVICE} (STATUS = $?)"
			exit 1
                else
			MOUNT_POINT=$(mount | grep ${DEVICE} | awk '{ print $3 }')
			INFO "${DEVICE} MOUNTED AT ${MOUNT_POINT}"
		fi	
	fi
	INFO "</${ACTION} - ${DEVICE}>"
}

do_umount()
{
        if ! udisksctl unmount -b ${DEVICE} ; then
                ERROR "ERROR UNMOUNTING ${DEVICE} (STATUS = $?)"
                exit 1
        fi
}

case "${ACTION}" in
    add)
        do_mount
        ;;
esac

