const express = require('express');
var mysql = require('mysql');
var async = require('async');
var axios = require('axios');
var cors = require('cors');
var cookieParser = require("cookie-parser");
var path = require('path');
const requestIp = require('request-ip');
const fs = require('fs');

const config = JSON.parse(fs.readFileSync('./config.json').toString());
const addr = "http://" + config.tg_api.address + ":" + config.tg_api.port;

const app = express();

const corsOpts = {
    origin: '*',

    methods: [
        'GET',
        'POST',
    ],

    allowedHeaders: [
        'Content-Type',
    ],
};

app.use(cors(corsOpts));
app.use(requestIp.mw())
app.use(express.json({ limit: '80mb' }));
app.use(express.urlencoded({ extended: true, limit: '80mb' }));
app.use(cookieParser());

var pool = mysql.createPool({
    host: config.db.address,
    user: config.db.username,
    password: config.db.password,
    database: config.db.schema,
    connectionLimit: 100,
    multipleStatements: true,
    charset: 'utf8mb4'
});

pool.getConnection(function (err, db) {

    if (err) {
        console.log(err);
        console.log("Nessuna connessione al database!");
    }

    setInterval(() => {
        db.query("SELECT NOW()", (qerr, re) => { });
    }, 60000);

    // SERVIZI AUTOMATICI

    setInterval(() => {
        syncMonitors();
        syncSchedule();
    }, 10000);

    // FINE SERVIZI AUTOMATICI

    app.get('/api/get/whatdoido/:identifier', async (req, res) => {

        // API chiamata dai monitor al mount, non ha senso mettere un token ed è sola lettura anyway

        let { referer } = req.headers;
        let port_check = 0;

        // Sub x nginx che non ritorna la port nell'header, fixettino piccolo finchè lo risolvo.
        //port_check = Number(referer.split(":").reverse()[0].replace('/', ''));
        port_check = Number(req.params.identifier);


        // *OLD* Cerco a quale id monitor fa riferimento questa richiesta
        // for (let i = 0; i < config.monitors.length; i++) if (Number(config.monitors[i].port) === Number(port_check)) { id_monitor = config.monitors[i].id_monitor; break; }

        // I MOINTORS stanno nel DB, le porte sono lette da lì, se la porta non è configurata ritorniamo unknown_monitor 
        const id_monitor = await new Promise((resolve_id) => {

            db.query("SELECT id_monitor FROM tg_monitor_setup WHERE nginx_port = ?", [port_check], (qerr, result) => {

                if (qerr || result.length === 0) return resolve_id(0);
                return resolve_id(result[0].id_monitor);

            })

        });

        if (id_monitor === 0) return res.status(500).send({ error: "UNKNOWN_MONITOR" }); // ritorno errore monitor sconosciuto se non è configurato.

        // Monitor identificato, Chiedo alle API cosa deve fare questo monitor
        // * OLD* ora, abbiamo lo schedule salvato e syncato localmente. non devo più chiedere all'esterno cosa devo fare.
        /*axios({
            url: addr + "/api/get/monitorevent/" + Number(id_monitor),
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {
            return res.status(200).send(x.data);
        }).catch(error => {
            console.log(error)
            return res.sendStatus(500);
        });*/

        db.query("SELECT id, valid_from, valid_to, id_project, id_monitor, weekdays, project_payload, id_schedule_origin, virtual_scale, range_from, range_to, hash_project FROM tg_schedule WHERE id_monitor = ? ORDER BY id_schedule_origin", [id_monitor], (qerr, schedule) => {

            if (qerr) return res.status(500).send({ error: "SCHEDULE_OUT_SYNC" });
            return res.status(200).send(schedule)

        })

    });

    app.get('/api/get/upcomings', (req, res) => {

        // API chiamata dai progetti, non possiamo mettere un token.

        axios({
            url: addr + "/api/get/upcomings",
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        })

    });

    app.get('/api/get/screenstatus', (req, res) => {

        axios({
            url: addr + "/api/get/screenstatus",
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        })

    });


    app.get('/api/get/upcomings/theater/:id_screen', (req, res) => {

        // API chiamata dai progetti, non possiamo mettere un token.
        // la pagina deve anche fornire un id_sala

        axios({
            url: addr + "/api/get/upcomings/theater/" + req.params.id_screen,
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        })

    });



    app.get('/api/get/schedulepreview', (req, res) => {

        // API chiamata dai progetti, non possiamo mettere un token.

        axios({
            url: addr + "/api/get/schedulepreview",
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        });

    })

    app.get('/api/get/:id_playback/playback', (req, res) => {

        // API chiamata dai progetti, non possiamo mettere un token.

        axios({
            url: addr + "/api/get/" + Number(req.params.id_playback) + "/playback",
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        })

    })

    app.get('/api/get/screenevents/:id_screen', (req, res) => {

        // API chiamata dai progetti, non possiamo mettere un token.

        axios({
            url: addr + "/api/get/screenevents/" + Number(req.params.id_screen),
            method: 'get',
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.status(200).send(x.data);

        }).catch(error => {

            console.log(error)
            return res.sendStatus(500);

        })

    });

    app.get('/api/sync/monitors', (req, res) => {

        // JWT REQUIRED::::::::::::: questa richiesta necessita di un jwt (viene lanciata dal pannello, va protetta);

        syncMonitors().then(x => {
            return res.sendStatus(200);
        }).catch(error => {
            return res.sendStatus(500);
        })

    });

    app.get('/api/sync/schedule', (req, res) => {

        // JWT REQUIRED::::::::::::: questa richiesta necessita di un jwt (viene lanciata dal pannello, va protetta);
        syncSchedule().then(x => {
            return res.sendStatus(200);
        }).catch(error => {
            return res.sendStatus(500);
        })

    });

    app.post('/api/post/snapshot', (req, res) => {

        const { s, id } = req.body;
        const ip_from = req.clientIp;

        // devo mandare lo screenshot al cloud
        axios({
            url: addr + "/api/post/snapshot",
            method: 'post',
            data: {
                identifier: Number(id),
                ip_client: ip_from,
                base64: s,
            },
            headers: {
                Authorization: config.tg_api.api_key
            }
        }).then(x => {

            return res.sendStatus(200)

        }).catch(error => {

            return res.sendStatus(500);

        })

        //        return res.sendStatus(200);

    });

    function syncMonitors() {

        return new Promise((resolve_global, reject_global) => {

            axios({
                url: addr + "/api/get/fromlocal/monitors",
                method: 'get',
                headers: {
                    Authorization: config.tg_api.api_key
                }
            }).then(x => {

                //return res.status(200).send(x.data);
                // aggiorno il db

                db.query("SELECT * FROM tg_monitor_setup", async (qerr, monitors) => {

                    let restart_nginx = false;

                    if (qerr || typeof monitors === 'undefined') return reject_global();

                    // parso i monitor che ho nel db per vedere cosa ho e cosa non ho.
                    for (let i = 0; i < x.data.length; i++) {

                        const current_monitor = x.data[i];
                        await new Promise((resolvin) => {

                            let already_in = false;

                            // vediamo se questo monitor è in lista, se non c'è lo aggiungo
                            for (let j = 0; j < monitors.length; j++) {
                                if (Number(monitors[j].id_monitor) === Number(current_monitor.id)) { already_in = true; break; }
                            }

                            if (!already_in) {
                                db.query("INSERT INTO tg_monitor_setup (id_monitor, monitor_name, nginx_port) VALUES (?,?,?)", [current_monitor.id, current_monitor.name, current_monitor.port], (qerr, insert_) => {
                                    return resolvin();
                                });
                            } else {
                                // aggiorno il nome e basta (se fosse identico, non cambia nulla, non tocco ne id_monitor o porta >_> )
                                db.query("UPDATE tg_monitor_setup SET monitor_name = ? , nginx_port = ? WHERE id_monitor = ?", [current_monitor.name, current_monitor.port, current_monitor.id], (qerr, upd) => {

                                    return resolvin(); // NON SERVE PIù LA PARTE DI NGINX
                                    // LA TENGO MA NON LA CANCELLO

                                    if (current_monitor.port === 0) // sarebbe da skippare...
                                        return resolvin();

                                    const path_configuration = '/' + path.join('etc', 'nginx', 'sites-available', 'tg-monitor-' + current_monitor.port);
                                    const path_configuration_syslink = '/' + path.join('etc', 'nginx', 'sites-enabled', 'tg-monitor-' + current_monitor.port);

                                    // devo verificare se esiste il file di config in nxing
                                    const nginx_configuration = "server {\n" +
                                        "listen " + current_monitor.port + " default_server;\n" +
                                        "listen [::]:" + current_monitor.port + " default_server;\n\n" +
                                        "root /var/www/tgclient/client;\n\n" +
                                        "index index.html index.htm index.nginx-debian.html;\n\n" +
                                        "server_name _;\n\n" +
                                        "location / {\n\n" +
                                        "try_files $uri /index.html;\n\n" +
                                        "}\n" +
                                        "location /api {\n" +
                                        "proxy_pass http://127.0.0.1:45990;\n" +
                                        "}\n" +
                                        "}\n";

                                    if (!fs.existsSync(path_configuration)) {
                                        // non esiste la configurazione, la scrivo.

                                        fs.writeFileSync(path_configuration, nginx_configuration.toString());
                                        fs.symlinkSync(path_configuration, path_configuration_syslink, 'file');
                                        restart_nginx = true; // flaggo il restart


                                    } else {
                                        // esiste la configurazione, apro il file per controllare se la porta settata è corretta, se non lo fosse,
                                        // sovrascrivo la configurazione, flaggo ngninx per il restart e alla fine lo riavvio.

                                        const current_config = fs.readFileSync(path_configuration).toString();
                                        const split_config = current_config.split('\n');
                                        if (split_config[1].indexOf(current_monitor.port) < 0) {
                                            // la configurazione è da sovrascrivere e restartare l'nginx
                                            fs.writeFileSync(path_configuration, nginx_configuration.toString());
                                            fs.symlinkSync(path_configuration, path_configuration_syslink, 'file');
                                            restart_nginx = true; // flaggo il restart
                                        }

                                    }

                                    return resolvin();

                                });
                            }

                        });

                    }

                    // ora, faccio l'inverso, prendo i monitors locali e vedo se tutti sono sincronizzati, se uno dei miei monitors locali non è presente nella lista in arrivo,
                    // lo dovrei rimuovere?????

                    db.query("SELECT * FROM tg_monitor_setup", async (qerr, monitors) => {

                        for (let u = 0; u < monitors.length; u++) {

                            const in_exam = monitors[u];

                            await new Promise((resolve_) => {

                                let exists = false;

                                for (let w = 0; w < x.data.length; w++) {
                                    if (in_exam.id_monitor === x.data[w].id) { exists = true; break; }
                                }

                                if (!exists) {
                                    // se non esiste, va rimosso perchè nella response del cloud questo monitor non c'è più
                                    db.query("DELETE FROM tg_monitor_setup WHERE id_monitor = ?", [in_exam.id_monitor], (qerr, deletee) => {

                                        // dovrei cancellare il file di configurazione di nginx..
                                        const path_conf_to_delete = '/' + path.join('etc', 'nginx', 'sites-available', 'tg-monitor-' + in_exam.port);
                                        const path_conf_to_delete_syslink = '/' + path.join('etc', 'nginx', 'sites-enabled', 'tg-monitor-' + in_exam.port);

                                        if (fs.existsSync(path_conf_to_delete)) {

                                            fs.unlinkSync(path_conf_to_delete);
                                            fs.unlinkSync(path_conf_to_delete_syslink);
                                            restart_nginx = true; // flaggo il restart

                                        }

                                        return resolve_();

                                    });

                                } else return resolve_();

                            });

                        }

                        // fine resync......... dovrei scrivere la configurazioni degli nginx e aggiornarle\toglierle

                        // devo cancellare i file di config che non sono più utilizzati.
                        const { exec } = require('child_process');

                        if (restart_nginx) {
                            const ls_ = exec('service nginx restart', function (error, stdout, stderr) {
                                return resolve_global();
                            });
                        } else {
                            return resolve_global();
                        }

                    });

                })

            }).catch(error => {

                //return res.sendStatus(500);
                console.log(error);
                return reject_global();

            })

        })

    }

    function syncSchedule() {

        return new Promise((resolve_global, reject_global) => {

            axios({
                url: addr + "/api/get/monitors/schedule",
                method: 'get',
                headers: {
                    Authorization: config.tg_api.api_key
                }
            }).then(x => {

                //return res.status(200).send(x.data);
                // nella tabella di streamer dello scheduel dei monitors dobbiamo mettere l'id della schedule all'interno dell idscheduleorigin, così, se lo troviamo
                // andiamo a fare un update, altrimenti lo aggiungiamo\rimuoviamo nel caso in cui non esistesse, sostanzialmente la stessa identica cosa dei monitors sync

                // prendo la schedule attuale senza condizioni o niente
                db.query("SELECT * FROM tg_schedule", async (qerr, schedule_cinecloud) => {

                    if (qerr || typeof schedule_cinecloud === 'undefined') return reject_global();

                    // parso i monitor che ho nel db per vedere cosa ho e cosa non ho.
                    for (let i = 0; i < x.data.length; i++) {

                        const current_schedule = x.data[i];
                        await new Promise((resolvin) => {

                            let already_in = false;

                            // vediamo se questo monitor è in lista, se non c'è lo aggiungo
                            for (let j = 0; j < schedule_cinecloud.length; j++) {
                                if (Number(schedule_cinecloud[j].id_schedule_origin) === Number(current_schedule.id)) { already_in = true; break; }
                            }

                            if (!already_in) {
                                db.query("INSERT INTO tg_schedule (valid_from, valid_to, id_project, id_monitor, insert_date, weekdays, project_payload, id_schedule_origin, virtual_scale, range_from, range_to, hash_project) VALUES (?,?,?,?,NOW(),?,?,?,?,?,?,?)",
                                    [new Date(current_schedule.valid_from).toMysqlFormat(), new Date(current_schedule.valid_to).toMysqlFormat(), current_schedule.id_project, current_schedule.id_monitor, current_schedule.weekdays, current_schedule.project_payload, current_schedule.id, current_schedule.virtual_scale, current_schedule.range_from, current_schedule.range_to, current_schedule.hash], (qerr, insert_) => {

                                        console.log(qerr);

                                        return resolvin();
                                    });
                            } else {
                                // aggiorno il nome e basta (se fosse identico, non cambia nulla, non tocco ne id_monitor o porta >_> )
                                db.query("UPDATE tg_schedule SET valid_from = ? , valid_to = ?, id_project = ?, insert_date=NOW() , weekdays=?, project_payload=?, virtual_scale=?, range_from=?, range_to=?, hash_project=? WHERE id_schedule_origin = ?",
                                    [new Date(current_schedule.valid_from).toMysqlFormat(), new Date(current_schedule.valid_to).toMysqlFormat(), current_schedule.id_project, current_schedule.weekdays, current_schedule.project_payload, current_schedule.virtual_scale, current_schedule.range_from, current_schedule.range_to, current_schedule.hash, current_schedule.id], (qerr, upd) => {
                                        return resolvin();
                                    });
                            }

                        });

                    }

                    // rimuovo le schedule scomparse dal cloud

                    db.query("SELECT * FROM tg_schedule", async (qerr, schedule_cinecloud) => {

                        for (let u = 0; u < schedule_cinecloud.length; u++) {

                            const in_exam = schedule_cinecloud[u];

                            await new Promise((resolve_) => {

                                let exists = false;

                                for (let w = 0; w < x.data.length; w++) {
                                    if (in_exam.id_schedule_origin === x.data[w].id) { exists = true; break; }
                                }

                                if (!exists) {
                                    // se non esiste, va rimosso perchè nella response del cloud questo monitor non c'è più
                                    db.query("DELETE FROM tg_schedule WHERE id_schedule_origin = ?", [in_exam.id_schedule_origin], (qerr, deletee) => {
                                        return resolve_();
                                    })
                                } else return resolve_();

                            });

                        }

                        // fine resync......... dovrei scrivere la configurazioni degli nginx e aggiornarle\toglierle
                        //return res.sendStatus(200);
                        return resolve_global();


                    });

                });

            }).catch(error => {

                //return res.sendStatus(500);
                return reject_global();

            })

        })
    }

    app.listen(config.tg_api.local_api_port, '0.0.0.0');

});

Date.prototype.toMysqlFormat = function () {
    this.setTime(this.getTime() + Math.abs(this.getTimezoneOffset() * 60 * 1000));
    return this.getUTCFullYear() + "-" + twoDigits(1 + this.getUTCMonth()) + "-" + twoDigits(this.getUTCDate()) + " " + twoDigits(this.getUTCHours()) + ":" + twoDigits(this.getUTCMinutes()) + ":" + twoDigits(this.getUTCSeconds());
};

function twoDigits(d) {
    if (0 <= d && d < 10) return "0" + d.toString();
    if (-10 < d && d < 0) return "-0" + (-1 * d).toString();
    return d.toString();
}